/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.execution;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.util.ComponentLocationProvider;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;

public abstract class LocationExecutionContextProvider
extends ComponentLocationProvider
implements ExceptionContextProvider {
    protected static final QName SOURCE_ELEMENT_ANNOTATION_KEY = new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceElement");
    private static final Pattern URL_PATTERN = Pattern.compile("url=\"[a-z]*://([^@]*)@");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("address=\"[a-z]*://([^@]*)@");
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("password=\"([^\"]*)\"");
    private static final String PASSWORD_MASK = "<<credentials>>";
    public static final String PASSWORD_ATTRIBUTE_MASK = "password=\"%s\"";

    public static void addMetadataAnnotationsFromXml(Map<QName, Object> beanAnnotations, String xmlContent) {
        beanAnnotations.put(SOURCE_ELEMENT_ANNOTATION_KEY, xmlContent);
    }

    protected static String getSourceXML(AnnotatedObject element) {
        Object sourceXml = element.getAnnotation(SOURCE_ELEMENT_ANNOTATION_KEY);
        return sourceXml != null ? LocationExecutionContextProvider.maskPasswords(sourceXml.toString()) : null;
    }

    protected static String maskPasswords(String xml) {
        xml = LocationExecutionContextProvider.maskUrlPassword(xml, URL_PATTERN);
        Matcher matcher = PASSWORD_PATTERN.matcher(xml = LocationExecutionContextProvider.maskUrlPassword(xml, ADDRESS_PATTERN));
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(LocationExecutionContextProvider.maskPasswordAttribute(matcher.group(1)), LocationExecutionContextProvider.maskPasswordAttribute(PASSWORD_MASK));
        }
        xml = LocationExecutionContextProvider.maskUrlPassword(xml, PASSWORD_PATTERN);
        return xml;
    }

    private static String maskUrlPassword(String xml, Pattern pattern) {
        Matcher matcher = pattern.matcher(xml);
        if (matcher.find() && matcher.groupCount() > 0) {
            xml = xml.replaceAll(matcher.group(1), PASSWORD_MASK);
        }
        return xml;
    }

    private static String maskPasswordAttribute(String password) {
        return String.format(PASSWORD_ATTRIBUTE_MASK, password);
    }
}

