/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.message;

import java.io.Serializable;
import java.util.OptionalInt;

public class GroupCorrelation
implements Serializable {
    private static final long serialVersionUID = -5687080761804624442L;
    public static final String NOT_SET = "<not set>";
    private final int sequence;
    private final int groupSize;

    public static GroupCorrelation of(int sequence) {
        return new GroupCorrelation(sequence, OptionalInt.empty());
    }

    public static GroupCorrelation of(int sequence, int groupSize) {
        return new GroupCorrelation(sequence, OptionalInt.of(groupSize));
    }

    private GroupCorrelation(int sequence, OptionalInt groupSize) {
        this.sequence = sequence;
        this.groupSize = groupSize.orElse(-1);
    }

    public int getSequence() {
        return this.sequence;
    }

    public OptionalInt getGroupSize() {
        return this.groupSize > 0 ? OptionalInt.of(this.groupSize) : OptionalInt.empty();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(120);
        buf.append("{");
        buf.append("sequence=").append(this.getSequence());
        buf.append("; groupSize=").append(this.getGroupSize().isPresent() ? Integer.valueOf(this.getGroupSize().getAsInt()) : NOT_SET);
        buf.append('}');
        return buf.toString();
    }
}

