/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.routing;

import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.InternalEvent;

public final class AggregationContext {
    private static final Predicate failedEventsPredicate = new Predicate(){

        public boolean evaluate(Object object) {
            if (object == null) {
                return false;
            }
            InternalEvent event = (InternalEvent)object;
            return event.getError().isPresent();
        }
    };
    private final InternalEvent originalEvent;
    private final List<InternalEvent> events;

    public AggregationContext(InternalEvent originalEvent, List<InternalEvent> events) {
        Preconditions.checkArgument((events != null ? 1 : 0) != 0, (String)"events cannot be null");
        this.originalEvent = originalEvent;
        this.events = Collections.unmodifiableList(events);
    }

    public List<InternalEvent> collectEventsWithExceptions() {
        return (List)CollectionUtils.select(this.events, (Predicate)failedEventsPredicate);
    }

    public NavigableMap<String, Throwable> collectRouteExceptions() {
        TreeMap<String, Throwable> routes = new TreeMap<String, Throwable>();
        for (int i = 0; i < this.events.size(); ++i) {
            InternalEvent event = this.events.get(i);
            if (!failedEventsPredicate.evaluate((Object)event)) continue;
            routes.put(Integer.toString(i), ((Error)event.getError().get()).getCause());
        }
        return routes;
    }

    public List<InternalEvent> collectEventsWithoutExceptions() {
        return (List)CollectionUtils.selectRejected(this.events, (Predicate)failedEventsPredicate);
    }

    public InternalEvent getOriginalEvent() {
        return this.originalEvent;
    }

    public List<InternalEvent> getEvents() {
        return this.events;
    }
}

