/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.scheduler;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class SchedulerConfig {
    private final Integer maxConcurrentTasks;
    private final String schedulerPrefix;
    private final String schedulerName;
    private final Optional<Boolean> waitAllowed;
    private final Supplier<Long> shutdownTimeoutMillis;

    public static SchedulerConfig config() {
        return new SchedulerConfig();
    }

    private SchedulerConfig() {
        this.maxConcurrentTasks = null;
        this.schedulerPrefix = null;
        this.schedulerName = null;
        this.waitAllowed = Optional.empty();
        this.shutdownTimeoutMillis = () -> null;
    }

    private SchedulerConfig(Integer maxConcurrentTasks, String schedulerPrefix, String schedulerName, Optional<Boolean> waitAllowed, Supplier<Long> shutdownTimeoutMillis) {
        this.maxConcurrentTasks = maxConcurrentTasks;
        this.schedulerPrefix = schedulerPrefix;
        this.schedulerName = schedulerName;
        this.waitAllowed = waitAllowed;
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    public SchedulerConfig withMaxConcurrentTasks(int maxConcurrentTasks) {
        return new SchedulerConfig(maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, this.waitAllowed, this.shutdownTimeoutMillis);
    }

    public Integer getMaxConcurrentTasks() {
        return this.maxConcurrentTasks;
    }

    public SchedulerConfig withPrefix(String schedulerPrefix) {
        return new SchedulerConfig(this.maxConcurrentTasks, schedulerPrefix, this.schedulerName, this.waitAllowed, this.shutdownTimeoutMillis);
    }

    public SchedulerConfig withName(String schedulerName) {
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, schedulerName, this.waitAllowed, this.shutdownTimeoutMillis);
    }

    public String getSchedulerName() {
        return this.schedulerPrefix == null ? this.schedulerName : String.format("[%s].%s", this.schedulerPrefix, this.schedulerName);
    }

    public boolean hasName() {
        return this.schedulerName != null;
    }

    public SchedulerConfig withWaitAllowed(boolean waitAllowed) {
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, Optional.of(waitAllowed), this.shutdownTimeoutMillis);
    }

    public Optional<Boolean> getWaitAllowed() {
        return this.waitAllowed;
    }

    public SchedulerConfig withShutdownTimeout(Supplier<Long> shutdownTimeoutSupplier, TimeUnit shutdownTimeoutUnit) {
        Objects.requireNonNull(shutdownTimeoutUnit);
        return new SchedulerConfig(this.maxConcurrentTasks, this.schedulerPrefix, this.schedulerName, this.waitAllowed, () -> {
            long shutdownTimeout = (Long)shutdownTimeoutSupplier.get();
            this.validateTimeoutValue(shutdownTimeout);
            return shutdownTimeoutUnit.toMillis(shutdownTimeout);
        });
    }

    public SchedulerConfig withShutdownTimeout(long shutdownTimeout, TimeUnit shutdownTimeoutUnit) {
        Objects.requireNonNull(shutdownTimeoutUnit);
        this.validateTimeoutValue(shutdownTimeout);
        return this.withShutdownTimeout(() -> shutdownTimeout, shutdownTimeoutUnit);
    }

    private void validateTimeoutValue(long shutdownTimeout) {
        if (shutdownTimeout < 0L) {
            throw new IllegalArgumentException(String.format("'shutdownTimeout' must be a possitive long. %d passed", shutdownTimeout));
        }
    }

    public Supplier<Long> getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulerConfig that = (SchedulerConfig)o;
        if (this.maxConcurrentTasks != null ? !this.maxConcurrentTasks.equals(that.maxConcurrentTasks) : that.maxConcurrentTasks != null) {
            return false;
        }
        if (this.schedulerPrefix != null ? !this.schedulerPrefix.equals(that.schedulerPrefix) : that.schedulerPrefix != null) {
            return false;
        }
        if (this.schedulerName != null ? !this.schedulerName.equals(that.schedulerName) : that.schedulerName != null) {
            return false;
        }
        if (this.waitAllowed != null ? !this.waitAllowed.equals(that.waitAllowed) : that.waitAllowed != null) {
            return false;
        }
        return this.shutdownTimeoutMillis != null ? this.shutdownTimeoutMillis.equals(that.shutdownTimeoutMillis) : that.shutdownTimeoutMillis == null;
    }

    public int hashCode() {
        int result = this.maxConcurrentTasks != null ? this.maxConcurrentTasks.hashCode() : 0;
        result = 31 * result + (this.schedulerPrefix != null ? this.schedulerPrefix.hashCode() : 0);
        result = 31 * result + (this.schedulerName != null ? this.schedulerName.hashCode() : 0);
        result = 31 * result + (this.waitAllowed != null ? this.waitAllowed.hashCode() : 0);
        result = 31 * result + (this.shutdownTimeoutMillis != null ? this.shutdownTimeoutMillis.hashCode() : 0);
        return result;
    }
}

