/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.store;

import java.io.Serializable;
import java.util.List;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.store.AbstractObjectStoreSupport;
import org.mule.runtime.api.store.ObjectDoesNotExistException;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.PartitionableObjectStore;

public abstract class AbstractPartitionableObjectStore<T extends Serializable>
extends AbstractObjectStoreSupport<T>
implements PartitionableObjectStore<T> {
    public void open() throws ObjectStoreException {
        this.open("DEFAULT_PARTITION");
    }

    public void close() throws ObjectStoreException {
        this.close("DEFAULT_PARTITION");
    }

    public List<String> allKeys() throws ObjectStoreException {
        return this.allKeys("DEFAULT_PARTITION");
    }

    public boolean contains(String key) throws ObjectStoreException {
        return this.contains(key, "DEFAULT_PARTITION");
    }

    public void store(String key, T value) throws ObjectStoreException {
        this.store(key, value, "DEFAULT_PARTITION");
    }

    public T retrieve(String key) throws ObjectStoreException {
        return this.retrieve(key, "DEFAULT_PARTITION");
    }

    public T remove(String key) throws ObjectStoreException {
        return this.remove(key, "DEFAULT_PARTITION");
    }

    public void clear() throws ObjectStoreException {
        this.clear("DEFAULT_PARTITION");
    }

    public boolean contains(String key, String partitionName) throws ObjectStoreException {
        this.validateKeyAndPartitionName(key, partitionName);
        return this.doContains(key, partitionName);
    }

    protected abstract boolean doContains(String var1, String var2) throws ObjectStoreException;

    public void store(String key, T value, String partitionName) throws ObjectStoreException {
        this.validateKeyAndPartitionName(key, partitionName);
        this.doStore(key, value, partitionName);
    }

    protected abstract void doStore(String var1, T var2, String var3) throws ObjectStoreException;

    public T retrieve(String key, String partitionName) throws ObjectStoreException {
        this.validatePresentKeyInPartition(key, partitionName);
        return this.doRetrieve(key, partitionName);
    }

    protected abstract T doRetrieve(String var1, String var2) throws ObjectStoreException;

    public T remove(String key, String partitionName) throws ObjectStoreException {
        this.validatePresentKeyInPartition(key, partitionName);
        return this.doRemove(key, partitionName);
    }

    protected abstract T doRemove(String var1, String var2) throws ObjectStoreException;

    protected void validateKeyAndPartitionName(String key, String partitionName) throws ObjectStoreException {
        this.validateKey(key);
        if (partitionName == null || partitionName.trim().length() == 0) {
            throw new ObjectStoreException(I18nMessageFactory.createStaticMessage((String)"partition name cannot be null or blank"));
        }
    }

    protected void validatePresentKeyInPartition(String key, String partitionName) throws ObjectStoreException {
        this.validateKeyAndPartitionName(key, partitionName);
        if (!this.contains(key, partitionName)) {
            throw new ObjectDoesNotExistException(I18nMessageFactory.createStaticMessage((String)String.format("Key '%s' does not exist in partition '%s'", key, partitionName)));
        }
    }
}

