/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.transaction.xa;

import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.api.util.UUID;

public abstract class AbstractTransactionContext {
    protected String id = UUID.getUUID();
    protected long timeout;
    protected int status = 6;
    private boolean readOnly = true;
    private boolean suspended = false;
    protected boolean finished = false;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.id).append("[");
        sb.append(this.getStatusString());
        if (this.suspended) {
            sb.append(", suspended");
        }
        if (this.readOnly) {
            sb.append(", readonly");
        }
        if (this.finished) {
            sb.append(", finished");
        }
        sb.append("]");
        return sb.toString();
    }

    private String getStatusString() {
        switch (this.status) {
            case 0: {
                return "active";
            }
            case 1: {
                return "marked rollback";
            }
            case 2: {
                return "prepared";
            }
            case 3: {
                return "committed";
            }
            case 4: {
                return "rolled back";
            }
            case 5: {
                return "unknown";
            }
            case 6: {
                return "no transaction";
            }
            case 7: {
                return "preparing";
            }
            case 8: {
                return "committing";
            }
            case 9: {
                return "rolling back";
            }
        }
        return "undefined status";
    }

    public synchronized void finalCleanUp() throws ResourceManagerException {
    }

    public synchronized void notifyFinish() {
        this.finished = true;
        this.notifyAll();
    }

    public abstract void doCommit() throws ResourceManagerException;

    public abstract void doRollback() throws ResourceManagerException;
}

