/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util.monitor;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.monitor.Expirable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiryMonitor
implements Runnable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpiryMonitor.class);
    private Scheduler scheduler;
    private Map<Expirable, ExpirableHolder> monitors;
    private long monitorFrequency;
    private String name;
    private MuleContext muleContext;
    private boolean onPollingNodeOnly;

    public ExpiryMonitor(MuleContext muleContext, boolean onPollingNodeOnly) {
        this.muleContext = muleContext;
        this.onPollingNodeOnly = onPollingNodeOnly;
    }

    public ExpiryMonitor(String name, long monitorFrequency, MuleContext muleContext, boolean onPollingNodeOnly) {
        this(muleContext, onPollingNodeOnly);
        this.name = name;
        this.monitorFrequency = monitorFrequency;
        this.init();
    }

    protected void init() {
        if (this.monitorFrequency <= 0L) {
            throw new IllegalArgumentException(CoreMessages.propertyHasInvalidValue("monitorFrequency", this.monitorFrequency).toString());
        }
        this.monitors = new ConcurrentHashMap<Expirable, ExpirableHolder>();
        if (this.scheduler == null) {
            this.scheduler = this.muleContext.getSchedulerService().customScheduler(this.muleContext.getSchedulerBaseConfig().withName(this.name + ".expiry.monitor").withMaxConcurrentTasks(1));
            this.scheduler.scheduleWithFixedDelay((Runnable)this, 0L, this.monitorFrequency, TimeUnit.MILLISECONDS);
        }
    }

    public void addExpirable(long value, TimeUnit timeUnit, Expirable expirable) {
        if (this.isRegistered(expirable)) {
            this.resetExpirable(expirable);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding new expirable: " + expirable);
            }
            this.monitors.put(expirable, new ExpirableHolder(timeUnit.toMillis(value), expirable));
        }
    }

    public boolean isRegistered(Expirable expirable) {
        return this.monitors.containsKey(expirable);
    }

    public void removeExpirable(Expirable expirable) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Removing expirable: " + expirable);
        }
        this.monitors.remove(expirable);
    }

    public void resetExpirable(Expirable expirable) {
        ExpirableHolder eh = this.monitors.get(expirable);
        if (eh != null) {
            eh.reset();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reset expirable: " + expirable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.onPollingNodeOnly || this.muleContext == null || this.muleContext.isPrimaryPollingInstance()) {
            Map<Expirable, ExpirableHolder> map = this.monitors;
            synchronized (map) {
                for (ExpirableHolder holder : this.monitors.values()) {
                    if (!holder.isExpired()) continue;
                    this.removeExpirable(holder.getExpirable());
                    holder.getExpirable().expired();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LOGGER.info("disposing monitor");
        this.scheduler.stop();
        Map<Expirable, ExpirableHolder> map = this.monitors;
        synchronized (map) {
            Iterator<ExpirableHolder> iterator = this.monitors.values().iterator();
            while (iterator.hasNext()) {
                ExpirableHolder element;
                ExpirableHolder holder = element = iterator.next();
                this.removeExpirable(holder.getExpirable());
                try {
                    holder.getExpirable().expired();
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
    }

    public String toString() {
        return String.format("ExpiryMonitor {monitorFrequency: %d, monitors: %s}", this.monitorFrequency, this.monitors.toString());
    }

    private static class ExpirableHolder {
        private Expirable expirable;
        private long milliseconds;
        private long created;

        public ExpirableHolder(long milliseconds, Expirable expirable) {
            this.milliseconds = milliseconds;
            this.expirable = expirable;
            this.created = System.currentTimeMillis();
        }

        public Expirable getExpirable() {
            return this.expirable;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.milliseconds > this.created;
        }

        public void reset() {
            this.created = System.currentTimeMillis();
        }

        public String toString() {
            return String.format("ExpirableHolder {expirable: %s, milliseconds: %d, created: %d}", this.expirable.toString(), this.milliseconds, this.created);
        }
    }
}

