/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.DefaultValidationResult;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.el.GlobalBindingContextProvider;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.TemplateParser;
import org.mule.runtime.core.el.DataWeaveExpressionLanguageAdaptor;
import org.mule.runtime.core.el.ExpressionLanguageAdaptorHandler;
import org.mule.runtime.core.el.mvel.MVELExpressionLanguage;
import org.mule.runtime.core.internal.util.OneTimeWarning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionManager
implements ExtendedExpressionManager,
Initialisable {
    public static final String DW_PREFIX = "dw";
    public static final String MEL_PREFIX = "mel";
    public static final String PREFIX_EXPR_SEPARATOR = ":";
    static final int DW_PREFIX_LENGTH = "dw:".length();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExpressionManager.class);
    private final OneTimeWarning parseWarning = new OneTimeWarning(LOGGER, "Expression parsing is deprecated, regular evaluations should be used instead.");
    private final MuleContext muleContext;
    private final StreamingManager streamingManager;
    private final ExtendedExpressionLanguageAdaptor expressionLanguage;
    private final TemplateParser parser = TemplateParser.createMuleStyleParser();
    private final boolean melDefault;

    @Inject
    public DefaultExpressionManager(MuleContext muleContext, StreamingManager streamingManager) {
        this.muleContext = muleContext;
        this.streamingManager = streamingManager;
        DataWeaveExpressionLanguageAdaptor dwExpressionLanguage = DataWeaveExpressionLanguageAdaptor.create(muleContext);
        MVELExpressionLanguage mvelExpressionLanguage = (MVELExpressionLanguage)muleContext.getRegistry().lookupObject("_muleExpressionLanguage");
        this.expressionLanguage = new ExpressionLanguageAdaptorHandler(dwExpressionLanguage, mvelExpressionLanguage);
        this.melDefault = ((ExpressionLanguageAdaptorHandler)this.expressionLanguage).isMelDefault();
    }

    public void initialise() throws InitialisationException {
        Collection<GlobalBindingContextProvider> contextProviders = this.muleContext.getRegistry().lookupObjects(GlobalBindingContextProvider.class);
        contextProviders.stream().map(GlobalBindingContextProvider::getBindingContext).forEach(this.expressionLanguage::addGlobalBindings);
        if (this.melDefault) {
            LOGGER.warn("Using MEL as the default expression language.");
        }
    }

    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionLanguage.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue evaluate(String expression) {
        return this.evaluate(expression, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event) {
        return this.evaluate(expression, event, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    public TypedValue evaluate(String expression, BindingContext context) {
        return this.evaluate(expression, null, null, null, context);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, BindingContext context) {
        return this.evaluate(expression, event, InternalEvent.builder(event), null, context);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, ComponentLocation componentLocation) {
        return this.evaluate(expression, event, InternalEvent.builder(event), componentLocation, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation) {
        return this.evaluate(expression, event, eventBuilder, componentLocation, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue evaluate(String expression, InternalEvent event, ComponentLocation componentLocation, BindingContext context) {
        return this.evaluate(expression, event, InternalEvent.builder(event), componentLocation, context);
    }

    private TypedValue evaluate(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext context) {
        return StreamingUtils.updateTypedValueForStreaming(this.expressionLanguage.evaluate(expression, event, eventBuilder, componentLocation, context), event, this.streamingManager);
    }

    @Override
    public TypedValue evaluate(String expression, DataType outputType) {
        return this.evaluate(expression, outputType, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    public TypedValue evaluate(String expression, DataType outputType, BindingContext context) {
        return this.evaluate(expression, outputType, context, null);
    }

    @Override
    public TypedValue evaluate(String expression, DataType outputType, BindingContext context, InternalEvent event) {
        return this.evaluate(expression, outputType, context, event, null, false);
    }

    @Override
    public TypedValue evaluate(String expression, DataType outputType, BindingContext context, InternalEvent event, ComponentLocation componentLocation, boolean failOnNull) throws ExpressionRuntimeException {
        return StreamingUtils.updateTypedValueForStreaming(this.expressionLanguage.evaluate(expression, outputType, event, componentLocation, context, failOnNull), event, this.streamingManager);
    }

    private TypedValue transform(TypedValue target, DataType sourceType, DataType outputType) throws TransformerException {
        if (target.getValue() != null && !ClassUtils.isInstance(outputType.getType(), target.getValue())) {
            Object result = this.muleContext.getRegistry().lookupTransformer(sourceType, outputType).transform(target.getValue());
            return new TypedValue(result, outputType);
        }
        return target;
    }

    @Override
    public void enrich(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation, TypedValue value) {
        this.expressionLanguage.enrich(expression, event, eventBuilder, componentLocation, value);
    }

    @Override
    public boolean evaluateBoolean(String expression, InternalEvent event, ComponentLocation componentLocation) throws ExpressionRuntimeException {
        return this.evaluateBoolean(expression, event, componentLocation, false, false);
    }

    @Override
    public boolean evaluateBoolean(String expression, InternalEvent event, ComponentLocation componentLocation, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        return this.resolveBoolean(this.evaluate(expression, DataType.BOOLEAN, BindingContextUtils.NULL_BINDING_CONTEXT, event, componentLocation, false).getValue(), nullReturnsTrue, nonBooleanReturnsTrue, expression);
    }

    protected boolean resolveBoolean(Object result, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue, String expression) {
        if (result == null) {
            return nullReturnsTrue;
        }
        Object value = result;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (value.toString().toLowerCase().equalsIgnoreCase("false")) {
                return false;
            }
            if (result.toString().toLowerCase().equalsIgnoreCase("true")) {
                return true;
            }
            return nonBooleanReturnsTrue;
        }
        LOGGER.warn("Expression: " + expression + ", returned an non-boolean result. Returning: " + nonBooleanReturnsTrue);
        return nonBooleanReturnsTrue;
    }

    @Override
    public String parse(String expression, InternalEvent event, ComponentLocation componentLocation) throws ExpressionRuntimeException {
        InternalEvent.Builder eventBuilder = InternalEvent.builder(event);
        this.parseWarning.warn();
        if (DefaultExpressionManager.hasMelExpression(expression) || this.melDefault) {
            return this.parser.parse(token -> {
                Object result = this.evaluate(token, event, eventBuilder, componentLocation).getValue();
                if (result instanceof Message) {
                    return ((Message)result).getPayload().getValue();
                }
                return result;
            }, expression);
        }
        if (this.isExpression(expression)) {
            TypedValue evaluation = this.evaluate(expression, event, eventBuilder, componentLocation);
            try {
                return (String)this.transform(evaluation, evaluation.getDataType(), DataType.STRING).getValue();
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to transform %s to %s.", evaluation.getDataType(), DataType.STRING)), (Throwable)((Object)e));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("No expression marker found in expression '%s'. Parsing as plain String.", expression));
        }
        return expression;
    }

    private String parse(String expression, InternalEvent event, InternalEvent.Builder eventBuilder, ComponentLocation componentLocation) throws ExpressionRuntimeException {
        this.parseWarning.warn();
        if (DefaultExpressionManager.hasMelExpression(expression) || this.melDefault) {
            return this.parser.parse(token -> {
                Object result = this.evaluate(token, event, eventBuilder, componentLocation).getValue();
                if (result instanceof Message) {
                    return ((Message)result).getPayload().getValue();
                }
                return result;
            }, expression);
        }
        if (this.isExpression(expression)) {
            TypedValue evaluation = this.evaluate(expression, event, eventBuilder, componentLocation);
            try {
                return (String)this.transform(evaluation, evaluation.getDataType(), DataType.STRING).getValue();
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to transform %s to %s.", evaluation.getDataType(), DataType.STRING)), (Throwable)((Object)e));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("No expression marker found in expression '%s'. Parsing as plain String.", expression));
        }
        return expression;
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, InternalEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.expressionLanguage.split(expression, event, componentLocation, bindingContext);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, InternalEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.expressionLanguage.split(expression, event, bindingContext);
    }

    public boolean isExpression(String expression) {
        return expression.contains("#[");
    }

    public boolean isValid(String expression) {
        return this.validate(expression).isSuccess();
    }

    public ValidationResult validate(String expression) {
        if (!this.muleContext.getConfiguration().isValidateExpressions()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Validate expressions is turned off, no checking done for: " + expression);
            }
            return new DefaultValidationResult(true, null);
        }
        StringBuilder message = new StringBuilder();
        try {
            this.parser.validate(expression);
            AtomicBoolean valid = new AtomicBoolean(true);
            if (!expression.contains("#[")) {
                return this.expressionLanguage.validate(expression);
            }
            this.parser.parse(token -> {
                ValidationResult result;
                if (valid.get() && !(result = this.expressionLanguage.validate(token)).isSuccess()) {
                    valid.compareAndSet(true, false);
                    message.append(token).append(" is invalid\n");
                    message.append(result.errorMessage().orElse(""));
                }
                return null;
            }, expression);
        }
        catch (IllegalArgumentException e) {
            return ValidationResult.failure((String)e.getMessage(), (String)expression);
        }
        if (message.length() > 0) {
            return ValidationResult.failure((String)message.toString());
        }
        return ValidationResult.success();
    }

    public Iterator<TypedValue<?>> split(String expression, BindingContext context) {
        return this.expressionLanguage.split(expression, null, context);
    }

    public static boolean hasMelExpression(String expression) {
        return expression.contains("#[mel:");
    }
}

