/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.el.context.AbstractMapContext;

public class EventVariablesMapContext
extends AbstractMapContext<Object> {
    private InternalEvent event;
    private InternalEvent.Builder eventBuider;

    public EventVariablesMapContext(InternalEvent event, InternalEvent.Builder eventBuider) {
        this.event = event;
        this.eventBuider = eventBuider;
    }

    @Override
    public Object doGet(String key) {
        return InternalEvent.getVariableValueOrNull(key, this.event);
    }

    @Override
    public void doPut(String key, Object value) {
        this.eventBuider.addVariable(key, value);
        this.event = this.eventBuider.build();
    }

    @Override
    public void doRemove(String key) {
        this.eventBuider.removeVariable(key);
        this.event = this.eventBuider.build();
    }

    @Override
    public Set<String> keySet() {
        return this.event.getVariables().keySet();
    }

    @Override
    public void clear() {
        this.eventBuider.variables(Collections.emptyMap());
        this.event = this.eventBuider.build();
    }

    public String toString() {
        HashMap map = new HashMap();
        this.event.getVariables().forEach((key, value) -> {
            Object object = value != null ? value.getValue() : null;
            map.put(key, object);
        });
        return ((Object)map).toString();
    }
}

