/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.context;

import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.core.api.util.NetworkUtils;

public class ServerContext {
    public String getHost() throws UnknownHostException {
        return NetworkUtils.getLocalHost().getCanonicalHostName();
    }

    public String getIp() throws UnknownHostException {
        return NetworkUtils.getLocalHost().getHostAddress();
    }

    public TimeZone getTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String getTmpDir() {
        return SystemUtils.JAVA_IO_TMPDIR;
    }

    public String getFileSeparator() {
        return SystemUtils.FILE_SEPARATOR;
    }

    public Map<String, String> getEnv() {
        return System.getenv();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public String getOsName() {
        return SystemUtils.OS_NAME;
    }

    public String getOsArch() {
        return SystemUtils.OS_ARCH;
    }

    public String getOsVersion() {
        return SystemUtils.OS_VERSION;
    }

    public String getJavaVersion() {
        return SystemUtils.JAVA_VERSION;
    }

    public String getJavaVendor() {
        return SystemUtils.JAVA_VENDOR;
    }

    public String getUserName() {
        return SystemUtils.USER_NAME;
    }

    public String getUserHome() {
        return SystemUtils.USER_HOME;
    }

    public String getUserDir() {
        return SystemUtils.USER_DIR;
    }
}

