/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.el.function;

import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LRUMap;
import org.mule.runtime.core.api.el.ExpressionLanguageContext;
import org.mule.runtime.core.api.el.ExpressionLanguageFunction;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.el.context.MessageContext;

public class RegexExpressionLanguageFuntion
implements ExpressionLanguageFunction {
    private static final int SINGLE_CAPTURE_GROUP = 1;
    private static final int NO_CAPTURE_GROUP = 0;
    private Map<String, Pattern> patterns = Collections.synchronizedMap(new LRUMap(256));

    @Override
    public Object call(Object[] params, ExpressionLanguageContext context) {
        int numParams = params.length;
        if (numParams < 1 || numParams > 3) {
            throw new IllegalArgumentException("invalid number of arguments");
        }
        String regex = this.verifyRegex(params[0]);
        Object result = null;
        if (numParams == 1) {
            try {
                result = this.getMatches(regex, context.getVariable("message", MessageContext.class).payloadAs(String.class), 0, context);
            }
            catch (TransformerException e) {
                throw new RuntimeException("Unable to convert payload to string");
            }
        } else {
            String text = this.verifyText(params[1]);
            if (numParams == 2) {
                result = this.getMatches(regex, text, 0, context);
            } else if (numParams == 3) {
                result = this.getMatches(regex, text, this.verifyFlags(params[2]), context);
            }
        }
        return result;
    }

    protected String verifyRegex(Object regex) {
        if (regex == null) {
            throw new IllegalArgumentException("regular expression is null");
        }
        if (!(regex instanceof String)) {
            throw new IllegalArgumentException("regular expression is not a string");
        }
        return (String)regex;
    }

    protected String verifyText(Object text) {
        if (text == null) {
            throw new IllegalArgumentException("text is null");
        }
        if (!(text instanceof String)) {
            throw new IllegalArgumentException("text is not a string");
        }
        return (String)text;
    }

    protected int verifyFlags(Object flags) {
        if (flags == null) {
            return 0;
        }
        if (!(flags instanceof Integer)) {
            throw new IllegalArgumentException("regular expression flags is not an integer");
        }
        return (Integer)flags;
    }

    protected Object getMatches(String regex, String text, int flags, ExpressionLanguageContext context) {
        Matcher matcher = this.createMatcher(regex, text, flags);
        String[] result = null;
        if (matcher.matches()) {
            if (matcher.groupCount() == 0 || matcher.groupCount() == 1) {
                result = matcher.group(matcher.groupCount());
            } else {
                String[] matchedValues = new String[matcher.groupCount()];
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    matchedValues[i - 1] = matcher.group(i);
                }
                result = matchedValues;
            }
        }
        return result;
    }

    private Matcher createMatcher(String expression, String string, int flags) {
        Pattern pattern = this.patterns.get(expression + flags);
        if (pattern == null) {
            pattern = Pattern.compile(expression, flags);
            this.patterns.put(expression + flags, pattern);
        }
        return pattern.matcher(string);
    }
}

