/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.NoSuchElementException;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.PoolingConnectionHandler;

final class PoolingConnectionManagementStrategy<C>
extends ConnectionManagementStrategy<C> {
    private final PoolingProfile poolingProfile;
    private final ObjectPool<C> pool;
    private final PoolingListener<C> poolingListener;

    PoolingConnectionManagementStrategy(ConnectionProvider<C> connectionProvider, PoolingProfile poolingProfile, PoolingListener<C> poolingListener, MuleContext muleContext) {
        super(connectionProvider, muleContext);
        this.poolingProfile = poolingProfile;
        this.poolingListener = poolingListener;
        this.pool = this.createPool();
    }

    @Override
    public ConnectionHandler<C> getConnectionHandler() throws ConnectionException {
        try {
            return new PoolingConnectionHandler<C>(this.borrowConnection(), this.pool, this.poolingListener);
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new ConnectionException("Connection pool is exhausted", (Throwable)e);
        }
        catch (Exception e) {
            throw new ConnectionException("An exception was found trying to obtain a connection: " + e.getMessage(), (Throwable)e);
        }
    }

    private C borrowConnection() throws Exception {
        Object connection = this.pool.borrowObject();
        try {
            this.poolingListener.onBorrow(connection);
        }
        catch (Exception e) {
            this.pool.invalidateObject(connection);
            throw e;
        }
        return (C)connection;
    }

    @Override
    public void close() throws MuleException {
        try {
            this.pool.close();
        }
        catch (Exception e) {
            throw new DefaultMuleException(I18nMessageFactory.createStaticMessage((String)"Could not close connection pool"), (Throwable)e);
        }
    }

    private ObjectPool<C> createPool() {
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.maxIdle = this.poolingProfile.getMaxIdle();
        config.maxActive = this.poolingProfile.getMaxActive();
        config.maxWait = this.poolingProfile.getMaxWait();
        config.whenExhaustedAction = (byte)this.poolingProfile.getExhaustedAction();
        config.minEvictableIdleTimeMillis = this.poolingProfile.getMinEvictionMillis();
        config.timeBetweenEvictionRunsMillis = this.poolingProfile.getEvictionCheckIntervalMillis();
        GenericObjectPool genericPool = new GenericObjectPool((PoolableObjectFactory)new ObjectFactoryAdapter(), config);
        return genericPool;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    private class ObjectFactoryAdapter
    implements PoolableObjectFactory<C> {
        private ObjectFactoryAdapter() {
        }

        public C makeObject() throws Exception {
            return PoolingConnectionManagementStrategy.this.connectionProvider.connect();
        }

        public void destroyObject(C connection) throws Exception {
            PoolingConnectionManagementStrategy.this.connectionProvider.disconnect(connection);
        }

        public boolean validateObject(C obj) {
            return false;
        }

        public void activateObject(C connection) throws Exception {
        }

        public void passivateObject(C connection) throws Exception {
        }
    }
}

