/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeginAndResolveTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeginAndResolveTransactionInterceptor.class);
    private final ExecutionInterceptor<T> next;
    private final TransactionConfig transactionConfig;
    private final MuleContext muleContext;
    private final boolean processOnException;
    private boolean mustResolveAnyTransaction;

    public BeginAndResolveTransactionInterceptor(ExecutionInterceptor next, TransactionConfig transactionConfig, MuleContext muleContext, boolean processOnException, boolean mustResolveAnyTransaction) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.muleContext = muleContext;
        this.processOnException = processOnException;
        this.mustResolveAnyTransaction = mustResolveAnyTransaction;
    }

    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        byte action = this.transactionConfig.getAction();
        int timeout = this.transactionConfig.getTimeout();
        boolean resolveStartedTransaction = false;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (action == 1 || action == 2 && tx == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Beginning transaction");
            }
            executionContext.markTransactionStart();
            tx = this.transactionConfig.getFactory().beginTransaction(this.muleContext);
            tx.setTimeout(timeout);
            resolveStartedTransaction = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Transaction successfully started: " + tx);
            }
        }
        try {
            T result = this.next.execute(callback, executionContext);
            this.resolveTransactionIfRequired(resolveStartedTransaction);
            return result;
        }
        catch (MessagingException e) {
            if (this.processOnException) {
                this.resolveTransactionIfRequired(resolveStartedTransaction || this.mustResolveAnyTransaction);
            }
            throw e;
        }
    }

    private void resolveTransactionIfRequired(boolean mustResolveTransaction) throws TransactionException {
        Transaction transaction = TransactionCoordination.getInstance().getTransaction();
        if (mustResolveTransaction && transaction != null) {
            TransactionCoordination.getInstance().resolveTransaction();
        }
    }
}

