/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;

public class CommitTransactionInterceptor
implements ExecutionInterceptor<InternalEvent> {
    private final ExecutionInterceptor<InternalEvent> nextInterceptor;

    public CommitTransactionInterceptor(ExecutionInterceptor<InternalEvent> nextInterceptor) {
        this.nextInterceptor = nextInterceptor;
    }

    @Override
    public InternalEvent execute(ExecutionCallback<InternalEvent> callback, ExecutionContext executionContext) throws Exception {
        InternalEvent result = this.nextInterceptor.execute(callback, executionContext);
        if (executionContext.needsTransactionResolution()) {
            try {
                TransactionCoordination.getInstance().resolveTransaction();
            }
            catch (Exception e) {
                if (result == null) {
                    result = InternalEvent.getCurrentEvent();
                }
                throw new MessagingException(result, e);
            }
        }
        return result;
    }
}

