/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.ExternalTransactionAwareTransactionFactory;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;

public class ExternalTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private final ExecutionInterceptor<T> next;
    private TransactionConfig transactionConfig;
    private MuleContext muleContext;

    public ExternalTransactionInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig, MuleContext muleContext) {
        this.next = next;
        this.transactionConfig = transactionConfig;
        this.muleContext = muleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        Transaction joinedExternal = null;
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        try {
            TransactionFactory tmFactory;
            if (tx == null && this.muleContext != null && this.transactionConfig != null && this.transactionConfig.isInteractWithExternal() && (tmFactory = this.transactionConfig.getFactory()) instanceof ExternalTransactionAwareTransactionFactory) {
                ExternalTransactionAwareTransactionFactory externalTransactionFactory = (ExternalTransactionAwareTransactionFactory)tmFactory;
                joinedExternal = externalTransactionFactory.joinExternalTransaction(this.muleContext);
            }
            T t = this.next.execute(callback, executionContext);
            return t;
        }
        finally {
            if (joinedExternal != null) {
                TransactionCoordination.getInstance().unbindTransaction(joinedExternal);
            }
        }
    }
}

