/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.execution.FlowProcessingPhaseTemplate;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.api.execution.RequestResponseFlowProcessingPhaseTemplate;
import org.mule.runtime.core.api.execution.ResponseDispatchException;
import org.mule.runtime.core.api.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.api.scheduler.SchedulerBusyException;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowProcessingPhase
extends NotificationFiringProcessingPhase<FlowProcessingPhaseTemplate> {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof FlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(FlowProcessingPhaseTemplate flowProcessingPhaseTemplate, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        Runnable flowExecutionWork = () -> {
            try {
                FlowConstruct flowConstruct = (FlowConstruct)this.muleContext.getRegistry().get(messageProcessContext.getMessageSource().getRootContainerName());
                try {
                    AtomicReference exceptionThrownDuringFlowProcessing = new AtomicReference();
                    TransactionalExecutionTemplate<InternalEvent> transactionTemplate = TransactionalExecutionTemplate.createTransactionalExecutionTemplate(this.muleContext, messageProcessContext.getTransactionConfig().orElse(new MuleTransactionConfig()));
                    InternalEvent response = transactionTemplate.execute(() -> {
                        try {
                            Object message = flowProcessingPhaseTemplate.getOriginalMessage();
                            if (message == null) {
                                return null;
                            }
                            InternalEvent muleEvent = flowProcessingPhaseTemplate.getEvent();
                            muleEvent = flowProcessingPhaseTemplate.beforeRouteEvent(muleEvent);
                            muleEvent = flowProcessingPhaseTemplate.routeEvent(muleEvent);
                            muleEvent = flowProcessingPhaseTemplate.afterRouteEvent(muleEvent);
                            this.sendResponseIfNeccessary(messageProcessContext.getMessageSource(), flowConstruct, muleEvent, flowProcessingPhaseTemplate);
                            return muleEvent;
                        }
                        catch (Exception e) {
                            exceptionThrownDuringFlowProcessing.set(e);
                            throw e;
                        }
                    });
                    if (exceptionThrownDuringFlowProcessing.get() != null && !(exceptionThrownDuringFlowProcessing.get() instanceof ResponseDispatchException)) {
                        this.sendResponseIfNeccessary(messageProcessContext.getMessageSource(), flowConstruct, response, flowProcessingPhaseTemplate);
                    }
                    flowProcessingPhaseTemplate.afterSuccessfulProcessingFlow(response);
                }
                catch (ResponseDispatchException e) {
                    flowProcessingPhaseTemplate.afterFailureProcessingFlow(e);
                }
                catch (MessagingException e) {
                    this.sendFailureResponseIfNeccessary(messageProcessContext.getMessageSource(), flowConstruct, e, flowProcessingPhaseTemplate);
                    flowProcessingPhaseTemplate.afterFailureProcessingFlow(e);
                }
                phaseResultNotifier.phaseSuccessfully();
            }
            catch (Exception e) {
                block8: {
                    DefaultMuleException me = new DefaultMuleException(e);
                    try {
                        flowProcessingPhaseTemplate.afterFailureProcessingFlow(me);
                    }
                    catch (MuleException e1) {
                        this.logger.warn("Failure during exception processing in flow template: " + e.getMessage());
                        if (!this.logger.isDebugEnabled()) break block8;
                        this.logger.debug("Failure during exception processing in flow template: ", (Throwable)e);
                    }
                }
                phaseResultNotifier.phaseFailure(e);
            }
        };
        if (messageProcessContext.supportsAsynchronousProcessing()) {
            try {
                messageProcessContext.getFlowExecutionExecutor().execute(flowExecutionWork);
            }
            catch (SchedulerBusyException e) {
                phaseResultNotifier.phaseFailure(e);
            }
        } else {
            flowExecutionWork.run();
        }
    }

    private void sendFailureResponseIfNeccessary(MessageSource messageSource, FlowConstruct flow, MessagingException messagingException, FlowProcessingPhaseTemplate flowProcessingPhaseTemplate) throws MuleException {
        if (flowProcessingPhaseTemplate instanceof RequestResponseFlowProcessingPhaseTemplate) {
            this.fireNotification(messageSource, messagingException.getEvent(), flow, 806);
            ((RequestResponseFlowProcessingPhaseTemplate)flowProcessingPhaseTemplate).sendFailureResponseToClient(messagingException);
        }
    }

    private void sendResponseIfNeccessary(MessageSource messageSource, FlowConstruct flow, InternalEvent muleEvent, FlowProcessingPhaseTemplate flowProcessingPhaseTemplate) throws MuleException {
        if (flowProcessingPhaseTemplate instanceof RequestResponseFlowProcessingPhaseTemplate) {
            this.fireNotification(messageSource, muleEvent, flow, 805);
            ((RequestResponseFlowProcessingPhaseTemplate)flowProcessingPhaseTemplate).sendResponseToClient(muleEvent);
        }
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }
}

