/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.api.execution.MessageProcessingManager;
import org.mule.runtime.core.internal.execution.EndProcessPhase;
import org.mule.runtime.core.internal.execution.FlowProcessingPhase;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhase;
import org.mule.runtime.core.internal.execution.PhaseExecutionEngine;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.mule.runtime.core.internal.policy.PolicyManager;

public class MuleMessageProcessingManager
implements MessageProcessingManager,
MuleContextAware,
Initialisable {
    private final EndProcessPhase endProcessPhase = new EndProcessPhase();
    private MuleContext muleContext;
    private PhaseExecutionEngine phaseExecutionEngine;
    @Inject
    private PolicyManager policyManager;

    @Override
    public void processMessage(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        this.phaseExecutionEngine.process(messageProcessTemplate, messageProcessContext);
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void initialise() throws InitialisationException {
        Collection<MessageProcessPhase> registryMessageProcessPhases = this.muleContext.getRegistry().lookupObjects(MessageProcessPhase.class);
        ArrayList<MessageProcessPhase> messageProcessPhaseList = new ArrayList<MessageProcessPhase>();
        if (registryMessageProcessPhases != null) {
            messageProcessPhaseList.addAll(registryMessageProcessPhases);
        }
        messageProcessPhaseList.add(new ValidationPhase());
        messageProcessPhaseList.add(new FlowProcessingPhase());
        messageProcessPhaseList.add(new ModuleFlowProcessingPhase(this.policyManager));
        Collections.sort(messageProcessPhaseList, (messageProcessPhase, messageProcessPhase2) -> {
            int compareValue = 0;
            if (messageProcessPhase instanceof Comparable) {
                compareValue = ((Comparable)((Object)messageProcessPhase)).compareTo(messageProcessPhase2);
            }
            if (compareValue == 0 && messageProcessPhase2 instanceof Comparable) {
                compareValue = ((Comparable)((Object)messageProcessPhase2)).compareTo(messageProcessPhase) * -1;
            }
            return compareValue;
        });
        for (MessageProcessPhase messageProcessPhase3 : messageProcessPhaseList) {
            if (messageProcessPhase3 instanceof MuleContextAware) {
                ((MuleContextAware)((Object)messageProcessPhase3)).setMuleContext(this.muleContext);
            }
            if (!(messageProcessPhase3 instanceof Initialisable)) continue;
            ((Initialisable)messageProcessPhase3).initialise();
        }
        this.phaseExecutionEngine = new PhaseExecutionEngine(messageProcessPhaseList, this.muleContext.getExceptionListener(), this.endProcessPhase);
    }
}

