/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.transaction.xa.IllegalTransactionStateException;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;

public class ValidateTransactionalStateInterceptor<T>
implements ExecutionInterceptor<T> {
    private final ExecutionInterceptor<T> next;
    private final TransactionConfig transactionConfig;

    public ValidateTransactionalStateInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig) {
        this.next = next;
        this.transactionConfig = transactionConfig;
    }

    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        if (this.transactionConfig.getAction() == 5 && tx != null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionAvailableButActionIs("Never"));
        }
        if (this.transactionConfig.getAction() == 3 && tx == null) {
            throw new IllegalTransactionStateException(CoreMessages.transactionNotAvailableButActionIs("Always Join"));
        }
        return this.next.execute(callback, executionContext);
    }
}

