/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.keygenerator;

import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.MuleEventKeyGenerator;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.util.AttributeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionMuleEventKeyGenerator
implements MuleEventKeyGenerator,
MuleContextAware {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private AttributeEvaluator attributeEvaluator;

    @Override
    public String generateKey(InternalEvent event) {
        Object key = this.attributeEvaluator.resolveValue(event);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Generated key for event: " + event + " key: " + key);
        }
        if (key instanceof String) {
            return (String)key;
        }
        throw new IllegalStateException("Generated key must a String but was " + (key != null ? key.getClass().getName() : "null"));
    }

    public String getExpression() {
        return this.attributeEvaluator.getRawValue();
    }

    public void setExpression(String expression) {
        this.attributeEvaluator = new AttributeEvaluator(expression);
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.attributeEvaluator.initialize(muleContext.getExpressionManager());
    }
}

