/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle.phases;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.lifecycle.LifecycleObject;
import org.mule.runtime.core.api.lifecycle.LifecyclePhase;
import org.mule.runtime.core.api.lifecycle.LifecycleStateEnabled;
import org.mule.runtime.core.internal.config.ExceptionHelper;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecyclePhase
implements LifecyclePhase {
    protected final transient Logger logger = LoggerFactory.getLogger(DefaultLifecyclePhase.class);
    private Class<?> lifecycleClass;
    private final Method lifecycleMethod;
    private Set<LifecycleObject> orderedLifecycleObjects = new LinkedHashSet<LifecycleObject>(6);
    private Class<?>[] ignorredObjectTypes;
    private final String name;
    private final String oppositeLifecyclePhase;
    private Set<String> supportedPhases;

    public DefaultLifecyclePhase(String name, Class<?> lifecycleClass, String oppositeLifecyclePhase) {
        this.name = name;
        this.lifecycleClass = lifecycleClass;
        Set lifecycleMethodsCandidate = ReflectionUtils.getAllMethods(lifecycleClass, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)name)});
        this.lifecycleMethod = lifecycleMethodsCandidate.isEmpty() ? null : (Method)lifecycleMethodsCandidate.iterator().next();
        this.oppositeLifecyclePhase = oppositeLifecyclePhase;
    }

    protected List<?> sortLifecycleInstances(Collection<?> objects, LifecycleObject lo) {
        return new ArrayList(objects);
    }

    @Override
    public void addOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.add(lco);
    }

    @Override
    public void removeOrderedLifecycleObject(LifecycleObject lco) {
        this.orderedLifecycleObjects.remove(lco);
    }

    protected boolean ignoreType(Class<?> type) {
        if (this.ignorredObjectTypes == null) {
            return false;
        }
        for (Class<?> ignorredObjectType : this.ignorredObjectTypes) {
            if (!ignorredObjectType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<LifecycleObject> getOrderedLifecycleObjects() {
        return this.orderedLifecycleObjects;
    }

    @Override
    public void setOrderedLifecycleObjects(Set<LifecycleObject> orderedLifecycleObjects) {
        this.orderedLifecycleObjects = orderedLifecycleObjects;
    }

    @Override
    public Class<?>[] getIgnoredObjectTypes() {
        return this.ignorredObjectTypes;
    }

    @Override
    public void setIgnoredObjectTypes(Class<?>[] ignorredObjectTypes) {
        this.ignorredObjectTypes = ignorredObjectTypes;
    }

    @Override
    public Class<?> getLifecycleClass() {
        return this.lifecycleClass;
    }

    @Override
    public void setLifecycleClass(Class<?> lifecycleClass) {
        this.lifecycleClass = lifecycleClass;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getSupportedPhases() {
        return this.supportedPhases;
    }

    @Override
    public void setSupportedPhases(Set<String> supportedPhases) {
        this.supportedPhases = supportedPhases;
    }

    @Override
    public void registerSupportedPhase(String phase) {
        if (this.supportedPhases == null) {
            this.supportedPhases = new HashSet<String>();
        }
        this.supportedPhases.add(phase);
    }

    @Override
    public boolean isPhaseSupported(String phase) {
        if (this.getSupportedPhases() == null) {
            return false;
        }
        if (this.getSupportedPhases().contains("all")) {
            return true;
        }
        return this.getSupportedPhases().contains(phase);
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        if (!this.getLifecycleClass().isAssignableFrom(o.getClass())) {
            return;
        }
        if (o instanceof LifecycleStateEnabled) {
            if (((LifecycleStateEnabled)o).getLifecycleState().isPhaseComplete(this.getName())) {
                return;
            }
            if (!((LifecycleStateEnabled)o).getLifecycleState().isValidTransition(this.getName())) {
                return;
            }
        }
        try {
            this.lifecycleMethod.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            Throwable t = ExceptionHelper.unwrap((Throwable)e);
            if (t instanceof LifecycleException) {
                throw (LifecycleException)t;
            }
            throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(this.lifecycleMethod.getName(), o), org.mule.runtime.api.exception.ExceptionHelper.getNonMuleException((Throwable)t), o);
        }
    }

    @Override
    public String getOppositeLifecyclePhase() {
        return this.oppositeLifecyclePhase;
    }
}

