/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.management.stats.ComponentStatistics;
import org.mule.runtime.core.internal.management.stats.AbstractFlowConstructStatistics;

public class DefaultFlowConstructStatistics
extends AbstractFlowConstructStatistics {
    private static final long serialVersionUID = 5337576392583767442L;
    private final AtomicLong executionError = new AtomicLong(0L);
    private final AtomicLong fatalError = new AtomicLong(0L);
    protected final ComponentStatistics flowStatistics = new ComponentStatistics();

    public DefaultFlowConstructStatistics(String flowConstructType, String name) {
        super(flowConstructType, name);
        this.flowStatistics.setEnabled(this.enabled);
        if (this.getClass() == DefaultFlowConstructStatistics.class) {
            this.clear();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void incExecutionError() {
        this.executionError.addAndGet(1L);
    }

    @Override
    public void incFatalError() {
        this.fatalError.addAndGet(1L);
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        super.setEnabled(b);
        this.flowStatistics.setEnabled(this.enabled);
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.executionError.set(0L);
        this.fatalError.set(0L);
        if (this.flowStatistics != null) {
            this.flowStatistics.clear();
        }
    }

    @Override
    public void addCompleteFlowExecutionTime(long time) {
        this.flowStatistics.addCompleteExecutionTime(time);
    }

    @Override
    public void addFlowExecutionBranchTime(long time, long total) {
        this.flowStatistics.addExecutionBranchTime(time == total, time, total);
    }

    @Override
    public long getAverageProcessingTime() {
        return this.flowStatistics.getAverageExecutionTime();
    }

    @Override
    public long getProcessedEvents() {
        return this.flowStatistics.getExecutedEvents();
    }

    @Override
    public long getMaxProcessingTime() {
        return this.flowStatistics.getMaxExecutionTime();
    }

    @Override
    public long getMinProcessingTime() {
        return this.flowStatistics.getMinExecutionTime();
    }

    @Override
    public long getTotalProcessingTime() {
        return this.flowStatistics.getTotalExecutionTime();
    }

    @Override
    public long getExecutionErrors() {
        return this.executionError.get();
    }

    @Override
    public long getFatalErrors() {
        return this.fatalError.get();
    }
}

