/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.metadata;

import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.internal.metadata.SimpleDataType;

public class DefaultMapDataType
extends SimpleDataType
implements MapDataType {
    private static final long serialVersionUID = 1052687171949146300L;
    private DataType keyType;
    private DataType valueType;

    DefaultMapDataType(Class<?> type, DataType keyType, DataType valueType, MediaType mimeType, boolean streamType) {
        super(type, mimeType, streamType);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public boolean isCompatibleWith(DataType dataType) {
        if (!(dataType instanceof DefaultMapDataType)) {
            return false;
        }
        if (!super.isCompatibleWith(dataType)) {
            return false;
        }
        DefaultMapDataType that = (DefaultMapDataType)dataType;
        return this.getKeyDataType().isCompatibleWith(that.getKeyDataType()) && this.getValueDataType().isCompatibleWith(that.getValueDataType());
    }

    public DataType getKeyDataType() {
        return this.keyType;
    }

    public DataType getValueDataType() {
        return this.valueType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMapDataType that = (DefaultMapDataType)o;
        if (!this.getKeyDataType().equals(that.getKeyDataType())) {
            return false;
        }
        if (!this.getValueDataType().equals(that.getValueDataType())) {
            return false;
        }
        if ((this.mimeType != null ? !this.mimeType.matches(that.mimeType) : that.mimeType != null) && !MediaType.ANY.matches(that.mimeType) && !MediaType.ANY.matches(this.mimeType)) {
            return false;
        }
        return this.getType().equals(that.getType());
    }

    @Override
    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getKeyDataType().hashCode();
        result = 31 * result + this.getValueDataType().hashCode();
        result = 31 * result + (this.getMediaType() != null ? this.getMediaType().hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "MapDataType{type=" + this.getType().getName() + ", keyType=" + this.getKeyDataType().toString() + ", valueType=" + this.getValueDataType().toString() + ", mimeType='" + this.getMediaType() + '\'' + '}';
    }
}

