/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.policy;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.policy.Policy;
import org.mule.runtime.core.api.policy.PolicyStateHandler;
import org.mule.runtime.core.api.policy.PolicyStateId;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.policy.PolicyEventConverter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class SourcePolicyProcessor
implements Processor {
    private final Policy policy;
    private final PolicyStateHandler policyStateHandler;
    private final PolicyEventConverter policyEventConverter = new PolicyEventConverter();
    private final Processor nextProcessor;

    public SourcePolicyProcessor(Policy policy, PolicyStateHandler policyStateHandler, Processor nextProcessor) {
        this.policy = policy;
        this.policyStateHandler = policyStateHandler;
        this.nextProcessor = nextProcessor;
    }

    @Override
    public InternalEvent process(InternalEvent sourceEvent) throws MuleException {
        return MessageProcessors.processToApply(sourceEvent, this);
    }

    @Override
    public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
        return Mono.from(publisher).then(sourceEvent -> {
            String executionIdentifier = sourceEvent.getContext().getCorrelationId();
            this.policyStateHandler.updateNextOperation(executionIdentifier, this.buildSourceExecutionWithPolicyFunction(executionIdentifier, (InternalEvent)sourceEvent));
            return Mono.just((Object)sourceEvent).map(event -> this.policyEventConverter.createEvent((InternalEvent)sourceEvent, InternalEvent.builder(sourceEvent.getContext()).message(Message.of(null)).build())).transform((Function)this.policy.getPolicyChain()).map(event -> this.policyEventConverter.createEvent((InternalEvent)event, (InternalEvent)sourceEvent));
        });
    }

    private Processor buildSourceExecutionWithPolicyFunction(final String executionIdentifier, final InternalEvent sourceEvent) {
        return new Processor(){

            @Override
            public InternalEvent process(InternalEvent event) throws MuleException {
                return MessageProcessors.processToApply(event, this);
            }

            @Override
            public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
                return Mono.from(publisher).then(event -> Mono.just((Object)event).doOnNext(request -> SourcePolicyProcessor.this.policyStateHandler.updateState(new PolicyStateId(executionIdentifier, SourcePolicyProcessor.this.policy.getPolicyId()), (InternalEvent)request)).map(request -> SourcePolicyProcessor.this.policyEventConverter.createEvent((InternalEvent)request, sourceEvent)).transform((Function)SourcePolicyProcessor.this.nextProcessor).map(result -> SourcePolicyProcessor.this.policyEventConverter.createEvent((InternalEvent)result, (InternalEvent)event)));
            }
        };
    }
}

