/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SubflowMessageProcessorChainBuilder
extends DefaultMessageProcessorChainBuilder {
    @Override
    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorForLifecycle) {
        return new SubFlowMessageProcessorChain(this.name, head, processors, processorForLifecycle);
    }

    static class SubFlowMessageProcessorChain
    extends DefaultMessageProcessorChainBuilder.DefaultMessageProcessorChain {
        private String subFlowName;

        SubFlowMessageProcessorChain(String name, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, Optional.empty(), head, processors, processorsForLifecycle);
            this.subFlowName = name;
        }

        private Consumer<InternalEvent> pushSubFlowFlowStackElement() {
            return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.subFlowName, null));
        }

        private Consumer<InternalEvent> popSubFlowFlowStackElement() {
            return event -> ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
        }

        @Override
        public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
            return Flux.from(publisher).concatMap(event -> Mono.just((Object)event).doOnNext(this.pushSubFlowFlowStackElement()).transform(s -> super.apply((Publisher<InternalEvent>)s)).doOnTerminate((event1, throwable) -> this.popSubFlowFlowStackElement().accept((InternalEvent)event)));
        }
    }
}

