/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.util.function.Function;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.Sink;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategyFactory;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.processor.strategy.AbstractProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.StreamPerEventSink;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlockingProcessingStrategyFactory
implements ProcessingStrategyFactory {
    public static final ProcessingStrategy BLOCKING_PROCESSING_STRATEGY_INSTANCE = new BlockingProcessingStrategy();

    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        return BLOCKING_PROCESSING_STRATEGY_INSTANCE;
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        return BLOCKING_PROCESSING_STRATEGY_INSTANCE.getClass();
    }

    private static class BlockingProcessingStrategy
    extends AbstractProcessingStrategy {
        private BlockingProcessingStrategy() {
        }

        @Override
        public boolean isSynchronous() {
            return true;
        }

        @Override
        public Sink createSink(FlowConstruct flowConstruct, ReactiveProcessor pipeline) {
            return new StreamPerEventSink(pipeline, event -> {});
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            return publisher -> Flux.from((Publisher)publisher).handle((event, sink) -> {
                try {
                    InternalEvent result = (InternalEvent)Mono.just((Object)event).transform((Function)processor).block();
                    if (result != null) {
                        sink.next((Object)result);
                    }
                }
                catch (Throwable throwable) {
                    sink.error(Exceptions.wrapFatal(Exceptions.unwrap(throwable)));
                }
            });
        }
    }
}

