/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.ReactorProcessingStrategyFactory;
import org.mule.runtime.core.internal.processor.strategy.ReactorStreamProcessingStrategyFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ProactorStreamProcessingStrategyFactory
extends ReactorStreamProcessingStrategyFactory {
    private static final ReactorProcessingStrategyFactory NOT_CONCURRENT_TX_AWARE_PS_FACTORY = new ReactorProcessingStrategyFactory();

    @Override
    public ProcessingStrategy create(MuleContext muleContext, String schedulersNamePrefix) {
        if (this.getMaxConcurrency() == 1) {
            return NOT_CONCURRENT_TX_AWARE_PS_FACTORY.create(muleContext, schedulersNamePrefix);
        }
        return new ProactorStreamProcessingStrategy(() -> muleContext.getSchedulerService().customScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + RING_BUFFER_SCHEDULER_NAME_SUFFIX).withMaxConcurrentTasks(this.getSubscriberCount() + 1)), this.getBufferSize(), this.getSubscriberCount(), this.getWaitStrategy(), () -> muleContext.getSchedulerService().cpuLightScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_LITE.name())), () -> muleContext.getSchedulerService().ioScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.BLOCKING.name())), () -> muleContext.getSchedulerService().cpuIntensiveScheduler(muleContext.getSchedulerBaseConfig().withName(schedulersNamePrefix + "." + ReactiveProcessor.ProcessingType.CPU_INTENSIVE.name())), this.getMaxConcurrency());
    }

    @Override
    public Class<? extends ProcessingStrategy> getProcessingStrategyType() {
        if (this.getMaxConcurrency() == 1) {
            return NOT_CONCURRENT_TX_AWARE_PS_FACTORY.getProcessingStrategyType();
        }
        return ProactorStreamProcessingStrategy.class;
    }

    static class ProactorStreamProcessingStrategy
    extends ReactorStreamProcessingStrategyFactory.ReactorStreamProcessingStrategy {
        private static Logger LOGGER = LoggerFactory.getLogger(ProactorStreamProcessingStrategy.class);
        private static int SCHEDULER_BUSY_RETRY_INTERVAL_MS = 10;
        private Supplier<org.mule.runtime.api.scheduler.Scheduler> blockingSchedulerSupplier;
        private Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuIntensiveSchedulerSupplier;
        private org.mule.runtime.api.scheduler.Scheduler blockingScheduler;
        private org.mule.runtime.api.scheduler.Scheduler cpuIntensiveScheduler;

        public ProactorStreamProcessingStrategy(Supplier<org.mule.runtime.api.scheduler.Scheduler> ringBufferSchedulerSupplier, int bufferSize, int subscriberCount, String waitStrategy, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuLightSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> blockingSchedulerSupplier, Supplier<org.mule.runtime.api.scheduler.Scheduler> cpuIntensiveSchedulerSupplier, int maxConcurrency) {
            super(ringBufferSchedulerSupplier, bufferSize, subscriberCount, waitStrategy, cpuLightSchedulerSupplier, maxConcurrency);
            this.blockingSchedulerSupplier = blockingSchedulerSupplier;
            this.cpuIntensiveSchedulerSupplier = cpuIntensiveSchedulerSupplier;
        }

        @Override
        public void start() throws MuleException {
            super.start();
            this.blockingScheduler = this.blockingSchedulerSupplier.get();
            this.cpuIntensiveScheduler = this.cpuIntensiveSchedulerSupplier.get();
        }

        @Override
        public void stop() throws MuleException {
            if (this.blockingScheduler != null) {
                this.blockingScheduler.stop();
            }
            if (this.cpuIntensiveScheduler != null) {
                this.cpuIntensiveScheduler.stop();
            }
            super.stop();
        }

        @Override
        public ReactiveProcessor onProcessor(ReactiveProcessor processor) {
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.BLOCKING && this.maxConcurrency > this.subscribers) {
                return this.proactor(processor, this.blockingScheduler);
            }
            if (processor.getProcessingType() == ReactiveProcessor.ProcessingType.CPU_INTENSIVE && this.maxConcurrency > this.subscribers) {
                return this.proactor(processor, this.cpuIntensiveScheduler);
            }
            return super.onProcessor(processor);
        }

        private ReactiveProcessor proactor(ReactiveProcessor processor, org.mule.runtime.api.scheduler.Scheduler scheduler) {
            return publisher -> Flux.from((Publisher)publisher).flatMap(event -> Flux.just((Object)event).transform((Function)processor).publishOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(this.getCpuLightScheduler()))).subscribeOn(Schedulers.fromExecutorService((ExecutorService)this.decorateScheduler(scheduler))).doOnError(RejectedExecutionException.class, throwable -> LOGGER.trace("Shared scheduler " + scheduler.getName() + " is busy.  Scheduling of the current event will be retried after " + SCHEDULER_BUSY_RETRY_INTERVAL_MS + "ms.")).retryWhen(errors -> errors.flatMap(error -> Mono.delay((Duration)Duration.ofMillis(SCHEDULER_BUSY_RETRY_INTERVAL_MS), (Scheduler)Schedulers.fromExecutorService((ExecutorService)this.getCpuLightScheduler())))), this.maxConcurrency);
        }
    }
}

