/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Comparator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.processor.Router;
import org.mule.runtime.core.internal.routing.AbstractAggregator;
import org.mule.runtime.core.internal.routing.correlation.CorrelationSequenceComparator;
import org.mule.runtime.core.internal.routing.correlation.EventCorrelatorCallback;
import org.mule.runtime.core.internal.routing.correlation.ResequenceMessagesCorrelatorCallback;

public class Resequencer
extends AbstractAggregator
implements Router {
    protected Comparator eventComparator;

    public Resequencer() {
        this.setEventComparator(new CorrelationSequenceComparator());
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.eventComparator == null) {
            throw new InitialisationException(CoreMessages.objectIsNull("eventComparator"), (Initialisable)this);
        }
        super.initialise();
    }

    public Comparator getEventComparator() {
        return this.eventComparator;
    }

    public void setEventComparator(Comparator eventComparator) {
        this.eventComparator = eventComparator;
    }

    @Override
    protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
        return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext, this.storePrefix);
    }

    @Override
    public InternalEvent process(InternalEvent event) throws MuleException {
        InternalEvent result = this.eventCorrelator.process(event);
        if (!this.isEventValid(result)) {
            return result;
        }
        InternalEvent last = null;
        for (InternalEvent muleEvent : (InternalEvent[])result.getMessage().getPayload().getValue()) {
            last = this.processNext(muleEvent);
        }
        return last;
    }
}

