/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.streaming.bytes;

import java.io.IOException;
import org.mule.runtime.api.streaming.Cursor;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.internal.streaming.CursorContext;
import org.mule.runtime.core.internal.streaming.CursorManager;
import org.mule.runtime.core.internal.streaming.ManagedCursorProvider;

public class ManagedCursorStreamProvider
extends ManagedCursorProvider<CursorStream>
implements CursorStreamProvider {
    public ManagedCursorStreamProvider(CursorContext cursorContext, CursorManager cursorManager) {
        super(cursorContext, cursorManager);
    }

    @Override
    protected CursorStream managedCursor(CursorStream cursor, CursorContext handle) {
        return new ManagedCursorDecorator(cursor, handle);
    }

    private class ManagedCursorDecorator
    extends CursorStream {
        private final CursorStream delegate;
        private final CursorContext cursorContext;

        private ManagedCursorDecorator(CursorStream delegate, CursorContext cursorContext) {
            this.delegate = delegate;
            this.cursorContext = cursorContext;
        }

        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                ManagedCursorStreamProvider.this.getCursorManager().onClose((Cursor)this.delegate, this.cursorContext);
            }
        }

        public long getPosition() {
            return this.delegate.getPosition();
        }

        public void seek(long position) throws IOException {
            this.delegate.seek(position);
        }

        public boolean isReleased() {
            return this.delegate.isReleased();
        }

        public void release() {
            this.delegate.release();
        }

        public CursorProvider getProvider() {
            return this.delegate.getProvider();
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        public int available() throws IOException {
            return this.delegate.available();
        }

        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        public void reset() throws IOException {
            this.delegate.reset();
        }

        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

