/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.core.api.transaction.TransactionFactory;
import org.mule.runtime.core.api.transaction.TypedTransactionFactory;

public final class TransactionFactoryLocator
implements Disposable {
    private final Map<TransactionType, TransactionFactory> factories = new HashMap<TransactionType, TransactionFactory>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TransactionFactory> lookUpTransactionFactory(TransactionType type) {
        TransactionFactory value;
        if (!this.initialized) {
            Lock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                if (!this.initialized) {
                    this.factories.putAll(this.getAvailableFactories());
                    this.initialized = true;
                }
            }
            finally {
                writeLock.unlock();
            }
        }
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            value = this.factories.get(type);
        }
        finally {
            readLock.unlock();
        }
        return Optional.ofNullable(value);
    }

    public void dispose() {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.factories.clear();
            this.initialized = false;
        }
        finally {
            writeLock.unlock();
        }
    }

    private Map<TransactionType, TypedTransactionFactory> getAvailableFactories() {
        HashMap<TransactionType, TypedTransactionFactory> factories = new HashMap<TransactionType, TypedTransactionFactory>();
        ServiceLoader.load(TypedTransactionFactory.class).forEach(factory -> factories.put(factory.getType(), (TypedTransactionFactory)factory));
        return factories;
    }
}

