/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.graph;

import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.internal.transformer.graph.ConverterFilter;
import org.mule.runtime.core.privileged.transformer.CompositeConverter;

public class TransformationLengthConverterFilter
implements ConverterFilter {
    @Override
    public List<Converter> filter(List<Converter> converters, DataType source, DataType result) {
        int index;
        if (converters.size() == 0) {
            return Collections.emptyList();
        }
        this.sortByTransformationLength(converters);
        int shortestLength = this.getTransformationLength(converters.get(0));
        for (index = 1; index < converters.size() && this.getTransformationLength(converters.get(index)) <= shortestLength; ++index) {
        }
        return converters.subList(0, index);
    }

    private void sortByTransformationLength(List<Converter> converterss) {
        Collections.sort(converterss, (converter, converter1) -> {
            int length = this.getTransformationLength((Converter)converter);
            int length1 = this.getTransformationLength((Converter)converter1);
            return length - length1;
        });
    }

    private int getTransformationLength(Converter converter) {
        if (converter instanceof CompositeConverter) {
            return ((CompositeConverter)converter).getConverters().size();
        }
        return 1;
    }
}

