/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.journal;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.internal.util.journal.JournalEntry;
import org.mule.runtime.core.internal.util.journal.JournalEntrySerializer;
import org.mule.runtime.core.internal.util.journal.TransactionCompletePredicate;
import org.mule.runtime.core.internal.util.journal.TransactionJournalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionJournal<T, K extends JournalEntry<T>> {
    public static final String TX1_LOG_FILE_NAME = "tx1.log";
    public static final String TX2_LOG_FILE_NAME = "tx2.log";
    private static final int MAXIMUM_LOG_FILE_ENTRIES = 50000;
    private static final int ONE_MEGABYTE_IN_BYTES = 0x100000;
    private transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TransactionCompletePredicate transactionCompletePredicate;
    private TransactionJournalFile<T, K> currentLogFile;
    private TransactionJournalFile<T, K> notCurrentLogFile;
    private Long maximumFileSizeInBytes;
    private Long clearFileMinimumSizeInBytes;

    public TransactionJournal(String logFilesDirectory, TransactionCompletePredicate transactionCompletePredicate, JournalEntrySerializer journalEntrySerializer, Integer maximumFileSizeInMegabytes) {
        File logFileDirectory = new File(logFilesDirectory);
        if (!logFileDirectory.exists()) {
            Preconditions.checkState((boolean)logFileDirectory.mkdirs(), (String)("Could not create directory for queue transaction logger " + logFileDirectory));
        }
        this.calculateJournalFileSize(maximumFileSizeInMegabytes);
        File logFile1 = new File(logFileDirectory, TX1_LOG_FILE_NAME);
        File logFile2 = new File(logFileDirectory, TX2_LOG_FILE_NAME);
        this.logger.info(String.format("Using files for tx logs %s and %s", logFile1.getAbsolutePath(), logFile2.getAbsolutePath()));
        this.currentLogFile = new TransactionJournalFile(logFile1, journalEntrySerializer, transactionCompletePredicate, this.clearFileMinimumSizeInBytes);
        this.notCurrentLogFile = new TransactionJournalFile(logFile2, journalEntrySerializer, transactionCompletePredicate, this.clearFileMinimumSizeInBytes);
        this.transactionCompletePredicate = transactionCompletePredicate;
    }

    private void calculateJournalFileSize(Integer maximumFileSizeInMegabytes) {
        if (maximumFileSizeInMegabytes != null) {
            this.maximumFileSizeInBytes = (long)maximumFileSizeInMegabytes.intValue() * 0x100000L / 2L;
            this.clearFileMinimumSizeInBytes = this.maximumFileSizeInBytes / 2L;
        }
    }

    public synchronized void logUpdateOperation(JournalEntry<T> journalEntry) {
        TransactionJournalFile logFile = this.determineLogFile(journalEntry.getTxId());
        logFile.logOperation(journalEntry);
    }

    public synchronized void logCheckpointOperation(JournalEntry<T> journalEntry) {
        TransactionJournalFile logFile = this.determineLogFile(journalEntry.getTxId());
        logFile.logOperation(journalEntry);
        if (this.transactionCompletePredicate.isTransactionComplete(journalEntry)) {
            logFile.clearEntriesForTransaction(journalEntry.getTxId());
        }
    }

    public Collection<K> getLogEntriesForTx(T txId) {
        TransactionJournalFile logFile = this.determineLogFileWithoutModifyingCurrent(txId);
        if (logFile == null || !logFile.containsTx(txId)) {
            return Collections.emptyList();
        }
        return logFile.getLogEntries(txId);
    }

    public synchronized Multimap<T, K> getAllLogEntries() {
        LinkedHashMultimap logEntries = LinkedHashMultimap.create();
        logEntries.putAll(this.currentLogFile.getAllLogEntries());
        logEntries.putAll(this.notCurrentLogFile.getAllLogEntries());
        return logEntries;
    }

    public synchronized void close() {
        this.currentLogFile.close();
        this.notCurrentLogFile.close();
    }

    public synchronized void clear() {
        this.currentLogFile.clear();
        this.notCurrentLogFile.clear();
    }

    private TransactionJournalFile determineLogFile(T txId) {
        TransactionJournalFile logFile = this.determineLogFileWithoutModifyingCurrent(txId);
        if (logFile != null) {
            return logFile;
        }
        if (this.maximumFileSizeInBytes == null) {
            if (this.currentLogFile.size() > 50000 && this.notCurrentLogFile.size() == 0) {
                this.debugLogFilesSwap();
                this.changeCurrentLogFile();
            }
        } else if (this.currentLogFile.fileLength() > this.maximumFileSizeInBytes && this.notCurrentLogFile.size() == 0) {
            this.debugLogFilesSwap();
            this.changeCurrentLogFile();
        }
        return this.currentLogFile;
    }

    private void debugLogFilesSwap() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Changing files, current file size: " + this.currentLogFile.fileLength() + " other file size: " + this.notCurrentLogFile.fileLength());
        }
    }

    private void changeCurrentLogFile() {
        TransactionJournalFile<T, K> aux = this.currentLogFile;
        this.currentLogFile = this.notCurrentLogFile;
        this.notCurrentLogFile = aux;
    }

    private TransactionJournalFile determineLogFileWithoutModifyingCurrent(T txId) {
        if (this.currentLogFile.containsTx(txId)) {
            return this.currentLogFile;
        }
        if (this.notCurrentLogFile.containsTx(txId)) {
            return this.notCurrentLogFile;
        }
        return null;
    }
}

