/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.core.privileged.util.annotation.AnnotationMetaData;

public class AnnotationUtils {
    public static List<AnnotationMetaData> getMethodAnnotations(Class<?> c, Class<? extends Annotation> ann) {
        return Arrays.asList(c.getMethods()).stream().filter(method -> method.isAnnotationPresent(ann)).map(method -> new AnnotationMetaData(c, (Member)method, ElementType.METHOD, (Annotation)method.getAnnotation(ann))).collect(Collectors.toList());
    }

    public static <T extends Annotation> Optional<T> getAnnotation(Class<?> aClass, Class<T> annotationType) {
        return aClass != null ? Optional.ofNullable(aClass.getAnnotation(annotationType)) : Optional.empty();
    }
}

