/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxBatch;
import reactor.core.scheduler.Scheduler;

final class FluxBufferTimeOrSize<T, C extends Collection<? super T>>
extends FluxBatch<T, C> {
    final Supplier<C> bufferSupplier;

    FluxBufferTimeOrSize(Flux<T> source, int maxSize, long timespan, Scheduler timer, Supplier<C> bufferSupplier) {
        super(source, maxSize, timespan, timer);
        this.bufferSupplier = Objects.requireNonNull(bufferSupplier, "bufferSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super C> subscriber) {
        this.source.subscribe(new BufferTimeoutSubscriber(this.prepareSub(subscriber), this.batchSize, this.timespan, this.timer.createWorker(), this.bufferSupplier));
    }

    static final class BufferTimeoutSubscriber<T, C extends Collection<? super T>>
    extends FluxBatch.BatchSubscriber<T, C> {
        final Supplier<C> bufferSupplier;
        volatile C values;

        BufferTimeoutSubscriber(Subscriber<? super C> actual, int maxSize, long timespan, Scheduler.Worker timer, Supplier<C> bufferSupplier) {
            super(actual, maxSize, false, timespan, timer);
            this.bufferSupplier = bufferSupplier;
        }

        @Override
        protected void doOnSubscribe() {
            this.values = (Collection)this.bufferSupplier.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkedError(Throwable ev) {
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                C v = this.values;
                if (v != null) {
                    v.clear();
                    this.values = null;
                }
            }
            this.actual.onError(ev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nextCallback(T value) {
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                Object v = this.values;
                if (v == null) {
                    this.values = v = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The bufferSupplier returned a null buffer");
                }
                v.add(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushCallback(T ev) {
            C v = this.values;
            boolean flush = false;
            BufferTimeoutSubscriber bufferTimeoutSubscriber = this;
            synchronized (bufferTimeoutSubscriber) {
                if (v != null && !v.isEmpty()) {
                    this.values = (Collection)this.bufferSupplier.get();
                    flush = true;
                }
            }
            if (flush) {
                this.actual.onNext(v);
            }
        }
    }
}

