/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxDistinct<T, K, C extends Collection<? super K>>
extends FluxSource<T, T> {
    final Function<? super T, ? extends K> keyExtractor;
    final Supplier<C> collectionSupplier;

    FluxDistinct(Flux<? extends T> source, Function<? super T, ? extends K> keyExtractor, Supplier<C> collectionSupplier) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
        this.collectionSupplier = Objects.requireNonNull(collectionSupplier, "collectionSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Collection collection;
        try {
            collection = (Collection)Objects.requireNonNull(this.collectionSupplier.get(), "The collectionSupplier returned a null collection");
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new DistinctConditionalSubscriber<T, K, Collection>((Fuseable.ConditionalSubscriber)s, collection, this.keyExtractor));
        } else {
            this.source.subscribe(new DistinctSubscriber<T, K, Collection>(s, collection, this.keyExtractor));
        }
    }

    static final class DistinctFuseableSubscriber<T, K, C extends Collection<? super K>>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final C collection;
        final Function<? super T, ? extends K> keyExtractor;
        Fuseable.QueueSubscription<T> qs;
        boolean done;
        int sourceMode;

        DistinctFuseableSubscriber(Subscriber<? super T> actual, C collection, Function<? super T, ? extends K> keyExtractor) {
            this.actual = actual;
            this.collection = collection;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.qs, s)) {
                this.qs = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.qs.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            K k;
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
                return true;
            }
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.qs, e, t));
                return true;
            }
            try {
                b = this.collection.add(k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.qs, e, t));
                return true;
            }
            if (b) {
                this.actual.onNext(t);
                return true;
            }
            return false;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.collection.clear();
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.collection.clear();
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.qs.request(n);
        }

        public void cancel() {
            this.qs.cancel();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            this.sourceMode = m = this.qs.requestFusion(requestedMode);
            return m;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.qs;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public T poll() {
            Object v;
            K r;
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.qs.poll()) == null) {
                        return null;
                    }
                    K r2 = Objects.requireNonNull(this.keyExtractor.apply(v2), "The keyExtractor returned a null collection");
                    if (this.collection.add(r2)) {
                        if (dropped != 0L) {
                            this.request(dropped);
                        }
                        return (T)v2;
                    }
                    ++dropped;
                }
            }
            do {
                if ((v = this.qs.poll()) != null) continue;
                return null;
            } while (!this.collection.add(r = Objects.requireNonNull(this.keyExtractor.apply(v), "The keyExtractor returned a null collection")));
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.qs.isEmpty();
        }

        @Override
        public void clear() {
            this.qs.clear();
            this.collection.clear();
        }

        @Override
        public int size() {
            return this.qs.size();
        }
    }

    static final class DistinctConditionalSubscriber<T, K, C extends Collection<? super K>>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final C collection;
        final Function<? super T, ? extends K> keyExtractor;
        Subscription s;
        boolean done;

        DistinctConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, C collection, Function<? super T, ? extends K> keyExtractor) {
            this.actual = actual;
            this.collection = collection;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            boolean b;
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            try {
                b = this.collection.add(k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (b) {
                this.actual.onNext(t);
            } else {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            try {
                b = this.collection.add(k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            return b && this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.collection.clear();
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.collection.clear();
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }
    }

    static final class DistinctSubscriber<T, K, C extends Collection<? super K>>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final C collection;
        final Function<? super T, ? extends K> keyExtractor;
        Subscription s;
        boolean done;

        DistinctSubscriber(Subscriber<? super T> actual, C collection, Function<? super T, ? extends K> keyExtractor) {
            this.actual = actual;
            this.collection = collection;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            boolean b;
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            try {
                b = this.collection.add(k);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (b) {
                this.actual.onNext(t);
                return true;
            }
            return false;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.collection.clear();
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.collection.clear();
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }
    }
}

