/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxDistinctUntilChanged<T, K>
extends FluxSource<T, T> {
    final Function<? super T, K> keyExtractor;

    FluxDistinctUntilChanged(Flux<? extends T> source, Function<? super T, K> keyExtractor) {
        super(source);
        this.keyExtractor = Objects.requireNonNull(keyExtractor, "keyExtractor");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new DistinctUntilChangedConditionalSubscriber<T, K>((Fuseable.ConditionalSubscriber)s, this.keyExtractor));
        } else {
            this.source.subscribe(new DistinctUntilChangedSubscriber<T, K>(s, this.keyExtractor));
        }
    }

    static final class DistinctUntilChangedConditionalSubscriber<T, K>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Function<? super T, K> keyExtractor;
        Subscription s;
        boolean done;
        K lastKey;

        DistinctUntilChangedConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Function<? super T, K> keyExtractor) {
            this.actual = actual;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (Objects.equals(this.lastKey, k)) {
                this.lastKey = k;
                return false;
            }
            this.lastKey = k;
            return this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }

    static final class DistinctUntilChangedSubscriber<T, K>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final Function<? super T, K> keyExtractor;
        Subscription s;
        boolean done;
        K lastKey;

        DistinctUntilChangedSubscriber(Subscriber<? super T> actual, Function<? super T, K> keyExtractor) {
            this.actual = actual;
            this.keyExtractor = keyExtractor;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (!this.tryOnNext(t)) {
                this.s.request(1L);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            K k;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                k = Objects.requireNonNull(this.keyExtractor.apply(t), "The distinct extractor returned a null value.");
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (Objects.equals(this.lastKey, k)) {
                this.lastKey = k;
                return false;
            }
            this.lastKey = k;
            this.actual.onNext(t);
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

