/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxScan<T>
extends FluxSource<T, T> {
    final BiFunction<T, ? super T, T> accumulator;

    FluxScan(Flux<? extends T> source, BiFunction<T, ? super T, T> accumulator) {
        super(source);
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new ScanSubscriber<T>(s, this.accumulator));
    }

    static final class ScanSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final BiFunction<T, ? super T, T> accumulator;
        Subscription s;
        T value;
        boolean done;

        ScanSubscriber(Subscriber<? super T> actual, BiFunction<T, ? super T, T> accumulator) {
            this.actual = actual;
            this.accumulator = accumulator;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            T v = this.value;
            if (v != null) {
                try {
                    t = Objects.requireNonNull(this.accumulator.apply(v, t), "The accumulator returned a null value");
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
            }
            this.value = t;
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.value != null ? 1 : 0;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

