/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.DrainUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxTakeLast<T>
extends FluxSource<T, T> {
    final int n;

    FluxTakeLast(Flux<? extends T> source, int n) {
        super(source);
        if (n < 0) {
            throw new IllegalArgumentException("n >= required but it was " + n);
        }
        this.n = n;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.n == 0) {
            this.source.subscribe(new TakeLastZeroSubscriber<T>(s));
        } else {
            this.source.subscribe(new TakeLastManySubscriber<T>(s, this.n));
        }
    }

    @Override
    public long getPrefetch() {
        return Integer.MAX_VALUE;
    }

    static final class TakeLastManySubscriber<T>
    extends ArrayDeque<T>
    implements BooleanSupplier,
    InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        final int n;
        volatile boolean cancelled;
        Subscription s;
        volatile long requested;
        static final AtomicLongFieldUpdater<TakeLastManySubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(TakeLastManySubscriber.class, "requested");

        TakeLastManySubscriber(Subscriber<? super T> actual, int n) {
            this.actual = actual;
            this.n = n;
        }

        @Override
        public boolean getAsBoolean() {
            return this.cancelled;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                DrainUtils.postCompleteRequest(n, this.actual, this, REQUESTED, this, this);
            }
        }

        public void cancel() {
            this.cancelled = true;
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.size() == this.n) {
                this.poll();
            }
            this.offer(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            DrainUtils.postComplete(this.actual, this, REQUESTED, this, this);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.cancelled;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
                case PARENT: {
                    return this.s;
                }
                case BUFFERED: {
                    return this.size();
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }

    static final class TakeLastZeroSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        Subscription s;

        TakeLastZeroSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

