/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxUsing<T, S>
extends Flux<T>
implements Fuseable {
    final Callable<S> resourceSupplier;
    final Function<? super S, ? extends Publisher<? extends T>> sourceFactory;
    final Consumer<? super S> resourceCleanup;
    final boolean eager;

    FluxUsing(Callable<S> resourceSupplier, Function<? super S, ? extends Publisher<? extends T>> sourceFactory, Consumer<? super S> resourceCleanup, boolean eager) {
        this.resourceSupplier = Objects.requireNonNull(resourceSupplier, "resourceSupplier");
        this.sourceFactory = Objects.requireNonNull(sourceFactory, "sourceFactory");
        this.resourceCleanup = Objects.requireNonNull(resourceCleanup, "resourceCleanup");
        this.eager = eager;
    }

    public void subscribe(Subscriber<? super T> s) {
        Publisher<? extends T> p;
        S resource;
        try {
            resource = this.resourceSupplier.call();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        try {
            p = Objects.requireNonNull(this.sourceFactory.apply(resource), "The sourceFactory returned a null value");
        }
        catch (Throwable e) {
            try {
                this.resourceCleanup.accept(resource);
            }
            catch (Throwable ex) {
                ex.addSuppressed(Operators.onOperatorError(e));
                e = ex;
            }
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (p instanceof Fuseable) {
            p.subscribe(new UsingFuseableSubscriber<T, S>(s, this.resourceCleanup, resource, this.eager));
        } else if (s instanceof Fuseable.ConditionalSubscriber) {
            p.subscribe(new UsingConditionalSubscriber((Fuseable.ConditionalSubscriber)s, this.resourceCleanup, resource, this.eager));
        } else {
            p.subscribe(new UsingSubscriber<T, S>(s, this.resourceCleanup, resource, this.eager));
        }
    }

    static final class UsingConditionalSubscriber<T, S>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Consumer<? super S> resourceCleanup;
        final S resource;
        final boolean eager;
        Subscription s;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<UsingConditionalSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(UsingConditionalSubscriber.class, "wip");

        UsingConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Consumer<? super S> resourceCleanup, S resource, boolean eager) {
            this.actual = actual;
            this.resourceCleanup = resourceCleanup;
            this.resource = resource;
            this.eager = eager;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: 
                case CANCELLED: {
                    return this.wip == 1;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (WIP.compareAndSet(this, 0, 1)) {
                this.s.cancel();
                this.cleanup();
            }
        }

        void cleanup() {
            try {
                this.resourceCleanup.accept(this.resource);
            }
            catch (Throwable e) {
                Operators.onErrorDropped(e);
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.actual.tryOnNext(t);
        }

        public void onError(Throwable t) {
            if (this.eager && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.resourceCleanup.accept(this.resource);
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e);
                    if (_e != t) {
                        _e.addSuppressed(t);
                    }
                    t = _e;
                }
            }
            this.actual.onError(t);
            if (!this.eager && WIP.compareAndSet(this, 0, 1)) {
                this.cleanup();
            }
        }

        public void onComplete() {
            if (this.eager && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.resourceCleanup.accept(this.resource);
                }
                catch (Throwable e) {
                    this.actual.onError(Operators.onOperatorError(e));
                    return;
                }
            }
            this.actual.onComplete();
            if (!this.eager && WIP.compareAndSet(this, 0, 1)) {
                this.cleanup();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public T poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    static final class UsingFuseableSubscriber<T, S>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final Consumer<? super S> resourceCleanup;
        final S resource;
        final boolean eager;
        Fuseable.QueueSubscription<T> s;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<UsingFuseableSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(UsingFuseableSubscriber.class, "wip");
        int mode;

        UsingFuseableSubscriber(Subscriber<? super T> actual, Consumer<? super S> resourceCleanup, S resource, boolean eager) {
            this.actual = actual;
            this.resourceCleanup = resourceCleanup;
            this.resource = resource;
            this.eager = eager;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: 
                case CANCELLED: {
                    return this.wip == 1;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (WIP.compareAndSet(this, 0, 1)) {
                this.s.cancel();
                this.cleanup();
            }
        }

        void cleanup() {
            try {
                this.resourceCleanup.accept(this.resource);
            }
            catch (Throwable e) {
                Operators.onErrorDropped(e);
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.eager && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.resourceCleanup.accept(this.resource);
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e);
                    if (_e != t) {
                        _e.addSuppressed(t);
                    }
                    t = _e;
                }
            }
            this.actual.onError(t);
            if (!this.eager && WIP.compareAndSet(this, 0, 1)) {
                this.cleanup();
            }
        }

        public void onComplete() {
            if (this.eager && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.resourceCleanup.accept(this.resource);
                }
                catch (Throwable e) {
                    this.actual.onError(Operators.onOperatorError(e));
                    return;
                }
            }
            this.actual.onComplete();
            if (!this.eager && WIP.compareAndSet(this, 0, 1)) {
                this.cleanup();
            }
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public T poll() {
            Object v = this.s.poll();
            if (v == null && this.mode == 1 && WIP.compareAndSet(this, 0, 1)) {
                this.resourceCleanup.accept(this.resource);
            }
            return (T)v;
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m;
            this.mode = m = this.s.requestFusion(requestedMode);
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }

    static final class UsingSubscriber<T, S>
    implements InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final Consumer<? super S> resourceCleanup;
        final S resource;
        final boolean eager;
        Subscription s;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<UsingSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(UsingSubscriber.class, "wip");

        UsingSubscriber(Subscriber<? super T> actual, Consumer<? super S> resourceCleanup, S resource, boolean eager) {
            this.actual = actual;
            this.resourceCleanup = resourceCleanup;
            this.resource = resource;
            this.eager = eager;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: 
                case CANCELLED: {
                    return this.wip == 1;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            if (WIP.compareAndSet(this, 0, 1)) {
                this.s.cancel();
                this.cleanup();
            }
        }

        void cleanup() {
            try {
                this.resourceCleanup.accept(this.resource);
            }
            catch (Throwable e) {
                Operators.onErrorDropped(e);
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.eager && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.resourceCleanup.accept(this.resource);
                }
                catch (Throwable e) {
                    Throwable _e = Operators.onOperatorError(e);
                    if (_e != t) {
                        _e.addSuppressed(t);
                    }
                    t = _e;
                }
            }
            this.actual.onError(t);
            if (!this.eager && WIP.compareAndSet(this, 0, 1)) {
                this.cleanup();
            }
        }

        public void onComplete() {
            if (this.eager && WIP.compareAndSet(this, 0, 1)) {
                try {
                    this.resourceCleanup.accept(this.resource);
                }
                catch (Throwable e) {
                    this.actual.onError(Operators.onOperatorError(e));
                    return;
                }
            }
            this.actual.onComplete();
            if (!this.eager && WIP.compareAndSet(this, 0, 1)) {
                this.cleanup();
            }
        }

        @Override
        public int requestFusion(int requestedMode) {
            return 0;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public T poll() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

