/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxBufferPredicate;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Operators;

final class FluxWindowPredicate<T>
extends FluxSource<T, GroupedFlux<T, T>>
implements Fuseable {
    final Supplier<? extends Queue<T>> groupQueueSupplier;
    final Supplier<? extends Queue<GroupedFlux<T, T>>> mainQueueSupplier;
    final FluxBufferPredicate.Mode mode;
    final Predicate<? super T> predicate;
    final int prefetch;

    FluxWindowPredicate(Flux<? extends T> source, Supplier<? extends Queue<GroupedFlux<T, T>>> mainQueueSupplier, Supplier<? extends Queue<T>> groupQueueSupplier, int prefetch, Predicate<? super T> predicate, FluxBufferPredicate.Mode mode) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.predicate = Objects.requireNonNull(predicate, "predicate");
        this.mainQueueSupplier = Objects.requireNonNull(mainQueueSupplier, "mainQueueSupplier");
        this.groupQueueSupplier = Objects.requireNonNull(groupQueueSupplier, "groupQueueSupplier");
        this.mode = mode;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super GroupedFlux<T, T>> s) {
        this.source.subscribe(new WindowPredicateMain<T>(s, this.mainQueueSupplier.get(), this.groupQueueSupplier, this.prefetch, this.predicate, this.mode));
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    static final class WindowGroupedFlux<T>
    extends GroupedFlux<T, T>
    implements Fuseable,
    Fuseable.QueueSubscription<T>,
    InnerOperator<T, T> {
        final T key;
        final Queue<T> queue;
        volatile WindowPredicateMain<T> parent;
        static final AtomicReferenceFieldUpdater<WindowGroupedFlux, WindowPredicateMain> PARENT = AtomicReferenceFieldUpdater.newUpdater(WindowGroupedFlux.class, WindowPredicateMain.class, "parent");
        volatile boolean done;
        Throwable error;
        volatile Subscriber<? super T> actual;
        static final AtomicReferenceFieldUpdater<WindowGroupedFlux, Subscriber> ACTUAL = AtomicReferenceFieldUpdater.newUpdater(WindowGroupedFlux.class, Subscriber.class, "actual");
        volatile boolean cancelled;
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowGroupedFlux> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowGroupedFlux.class, "once");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowGroupedFlux> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowGroupedFlux.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowGroupedFlux> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowGroupedFlux.class, "requested");
        volatile boolean enableOperatorFusion;
        int produced;

        @Override
        public T key() {
            return this.key;
        }

        WindowGroupedFlux(T key, Queue<T> queue, WindowPredicateMain<T> parent) {
            this.key = key;
            this.queue = queue;
            this.parent = parent;
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        void propagateTerminate() {
            WindowPredicateMain<T> r = this.parent;
            if (r != null && PARENT.compareAndSet(this, r, null)) {
                r.groupTerminated();
            }
        }

        void propagateCancel() {
            WindowPredicateMain<T> r = this.parent;
            if (r != null && PARENT.compareAndSet(this, r, null)) {
                r.cancel();
            }
        }

        void drainRegular(Subscriber<? super T> a) {
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; r != e; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    T t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (r == e && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L) continue;
                WindowPredicateMain<T> main = this.parent;
                if (main != null) {
                    main.s.request(e);
                }
                if (r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainFused(Subscriber<? super T> a) {
            int missed = 1;
            Queue<T> q = this.queue;
            do {
                if (this.cancelled) {
                    q.clear();
                    this.actual = null;
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                this.actual = null;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drain() {
            Subscriber<? super T> a = this.actual;
            if (a != null) {
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                if (this.enableOperatorFusion) {
                    this.drainFused(a);
                } else {
                    this.drainRegular(a);
                }
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                q.clear();
                this.actual = null;
                return true;
            }
            if (d && empty) {
                Throwable e = this.error;
                this.actual = null;
                if (e != null) {
                    a.onError(e);
                } else {
                    a.onComplete();
                }
                return true;
            }
            return false;
        }

        public void onNext(T t) {
            Subscriber<? super T> a = this.actual;
            if (!this.queue.offer(t)) {
                this.onError(Operators.onOperatorError(this, Exceptions.failWithOverflow("Queue is full?!"), t));
                return;
            }
            if (this.enableOperatorFusion) {
                if (a != null) {
                    a.onNext(null);
                }
            } else {
                this.drain();
            }
        }

        public void onSubscribe(Subscription s) {
        }

        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.propagateTerminate();
            this.drain();
        }

        public void onComplete() {
            this.done = true;
            this.propagateTerminate();
            this.drain();
        }

        public void subscribe(Subscriber<? super T> s) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                s.onSubscribe((Subscription)this);
                ACTUAL.lazySet(this, s);
                this.drain();
            } else {
                s.onError((Throwable)new IllegalStateException("This processor allows only a single Subscriber"));
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.propagateCancel();
            if (!this.enableOperatorFusion && WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        @Override
        public T poll() {
            T v = this.queue.poll();
            if (v != null) {
                ++this.produced;
            } else {
                int p = this.produced;
                if (p != 0) {
                    this.produced = 0;
                    WindowPredicateMain<T> main = this.parent;
                    if (main != null) {
                        main.s.request((long)p);
                    }
                }
            }
            return v;
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.parent;
                }
                case CANCELLED: {
                    return this.cancelled;
                }
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.queue == null ? 0 : this.queue.size();
                }
                case ERROR: {
                    return this.error;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public String toString() {
            return "WindowGroupedFlux[" + this.key + "]";
        }
    }

    static final class WindowPredicateMain<T>
    implements Fuseable.QueueSubscription<GroupedFlux<T, T>>,
    InnerOperator<T, GroupedFlux<T, T>> {
        final Subscriber<? super GroupedFlux<T, T>> actual;
        final Supplier<? extends Queue<T>> groupQueueSupplier;
        final FluxBufferPredicate.Mode mode;
        final Predicate<? super T> predicate;
        final int prefetch;
        final Queue<GroupedFlux<T, T>> queue;
        WindowGroupedFlux<T> window;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowPredicateMain> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowPredicateMain.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowPredicateMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowPredicateMain.class, "requested");
        volatile boolean done;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<WindowPredicateMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(WindowPredicateMain.class, Throwable.class, "error");
        volatile int cancelled;
        static final AtomicIntegerFieldUpdater<WindowPredicateMain> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(WindowPredicateMain.class, "cancelled");
        Subscription s;
        volatile boolean outputFused;

        WindowPredicateMain(Subscriber<? super GroupedFlux<T, T>> actual, Queue<GroupedFlux<T, T>> queue, Supplier<? extends Queue<T>> groupQueueSupplier, int prefetch, Predicate<? super T> predicate, FluxBufferPredicate.Mode mode) {
            this.actual = actual;
            this.queue = queue;
            this.groupQueueSupplier = groupQueueSupplier;
            this.prefetch = prefetch;
            this.predicate = predicate;
            this.mode = mode;
            this.initializeWindow();
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.cancelled == 0) {
                    if (this.prefetch == Integer.MAX_VALUE) {
                        s.request(Long.MAX_VALUE);
                    } else {
                        s.request((long)this.prefetch);
                    }
                }
            }
        }

        void initializeWindow() {
            WindowGroupedFlux<Object> g = new WindowGroupedFlux<Object>(null, this.groupQueueSupplier.get(), this);
            this.window = g;
            this.queue.offer(g);
        }

        void offerNewWindow(T key, T emitInNewWindow) {
            if (this.cancelled == 0) {
                WindowGroupedFlux<T> g = new WindowGroupedFlux<T>(key, this.groupQueueSupplier.get(), this);
                if (emitInNewWindow != null) {
                    g.onNext(emitInNewWindow);
                }
                this.window = g;
                if (!this.queue.offer(g)) {
                    this.onError(Operators.onOperatorError(this, Exceptions.failWithOverflow("Queue is full?!"), emitInNewWindow));
                    return;
                }
                this.drain();
            }
        }

        public void onNext(T t) {
            boolean match;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            WindowGroupedFlux<T> g = this.window;
            try {
                match = this.predicate.test(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (this.mode == FluxBufferPredicate.Mode.UNTIL && match) {
                g.onNext(t);
                g.onComplete();
                this.offerNewWindow(t, null);
            } else if (this.mode == FluxBufferPredicate.Mode.UNTIL_CUT_BEFORE && match) {
                g.onComplete();
                this.offerNewWindow(t, t);
            } else if (this.mode == FluxBufferPredicate.Mode.WHILE && !match) {
                g.onComplete();
                this.offerNewWindow(t, null);
                this.s.request(1L);
            } else {
                g.onNext(t);
            }
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            WindowGroupedFlux<T> g = this.window;
            if (g != null) {
                g.onComplete();
            }
            this.window = null;
            this.done = true;
            this.drain();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
                case CANCELLED: {
                    return this.cancelled == 1;
                }
                case PREFETCH: {
                    return this.prefetch;
                }
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.queue.size();
                }
                case ERROR: {
                    return this.error;
                }
                case REQUESTED_FROM_DOWNSTREAM: {
                    return this.requested;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return this.window == null ? Stream.empty() : Stream.of(this.window);
        }

        @Override
        public Subscriber<? super GroupedFlux<T, T>> actual() {
            return this.actual;
        }

        void signalAsyncError() {
            Throwable e = Exceptions.terminate(ERROR, this);
            WindowGroupedFlux<T> g = this.window;
            if (g != null) {
                g.onError(e);
            }
            this.actual.onError(e);
            this.window = null;
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1)) {
                this.s.cancel();
            }
        }

        void groupTerminated() {
            this.window = null;
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            if (this.outputFused) {
                this.drainFused();
            } else {
                this.drainLoop();
            }
        }

        void drainFused() {
            int missed = 1;
            Subscriber<? super GroupedFlux<T, T>> a = this.actual;
            Queue<GroupedFlux<T, T>> q = this.queue;
            do {
                if (this.cancelled != 0) {
                    q.clear();
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    this.signalAsyncError();
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainLoop() {
            int missed = 1;
            Subscriber<? super GroupedFlux<T, T>> a = this.actual;
            Queue<GroupedFlux<T, T>> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    GroupedFlux<T, T> v = q.poll();
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L) continue;
                this.s.request(e);
                if (r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<GroupedFlux<T, T>> q) {
            if (this.cancelled != 0) {
                q.clear();
                return true;
            }
            if (d) {
                Throwable e = this.error;
                if (e != null && e != Exceptions.TERMINATED) {
                    this.queue.clear();
                    this.signalAsyncError();
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public GroupedFlux<T, T> poll() {
            return this.queue.poll();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }
    }
}

