/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoHasElements<T>
extends MonoSource<T, Boolean>
implements Fuseable {
    MonoHasElements(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super Boolean> s) {
        if (this.source instanceof Mono) {
            this.source.subscribe(new HasElementSubscriber((Subscriber<? super Boolean>)((Subscriber<Boolean>)s)));
        } else {
            this.source.subscribe(new HasElementsSubscriber((Subscriber<? super Boolean>)((Subscriber<Boolean>)s)));
        }
    }

    static final class HasElementSubscriber<T>
    extends Operators.MonoSubscriber<T, Boolean> {
        Subscription s;

        HasElementSubscriber(Subscriber<? super Boolean> actual) {
            super(actual);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            return super.scan(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.complete(true);
        }

        @Override
        public void onComplete() {
            this.complete(false);
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }

    static final class HasElementsSubscriber<T>
    extends Operators.MonoSubscriber<T, Boolean> {
        Subscription s;

        HasElementsSubscriber(Subscriber<? super Boolean> actual) {
            super(actual);
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return super.scan(key);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.s.cancel();
            this.complete(true);
        }

        @Override
        public void onComplete() {
            this.complete(false);
        }
    }
}

