/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoIgnoreEmpty<T>
extends MonoSource<T, T> {
    MonoIgnoreEmpty(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new IgnoreElementsSubscriber<T>(s));
    }

    static final class IgnoreElementsSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        Subscription s;

        IgnoreElementsSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

