/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoNext<T>
extends MonoSource<T, T> {
    MonoNext(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new NextSubscriber<T>(s));
    }

    static final class NextSubscriber<T>
    implements InnerOperator<T, T> {
        final Subscriber<? super T> actual;
        Subscription s;
        boolean done;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<NextSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(NextSubscriber.class, "wip");

        NextSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.s.cancel();
            this.actual.onNext(t);
            this.onComplete();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        public void request(long n) {
            if (WIP.compareAndSet(this, 0, 1)) {
                this.s.request(Long.MAX_VALUE);
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }
    }
}

