/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoPeekTerminal<T>
extends MonoSource<T, T>
implements Fuseable {
    final BiConsumer<? super T, Throwable> onAfterTerminateCall;
    final BiConsumer<? super T, Throwable> onTerminateCall;
    final Consumer<? super T> onSuccessCall;

    MonoPeekTerminal(Mono<? extends T> source, Consumer<? super T> onSuccessCall, BiConsumer<? super T, Throwable> onTerminateCall, BiConsumer<? super T, Throwable> onAfterTerminateCall) {
        super(source);
        this.onAfterTerminateCall = onAfterTerminateCall;
        this.onTerminateCall = onTerminateCall;
        this.onSuccessCall = onSuccessCall;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new MonoTerminalPeekSubscriber((Fuseable.ConditionalSubscriber)s, this));
            return;
        }
        this.source.subscribe(new MonoTerminalPeekSubscriber<T>(s, this));
    }

    static final class MonoTerminalPeekSubscriber<T>
    implements Fuseable.ConditionalSubscriber<T>,
    InnerOperator<T, T>,
    Fuseable.QueueSubscription<T> {
        final Subscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final MonoPeekTerminal<T> parent;
        Subscription s;
        Fuseable.QueueSubscription<T> queueSubscription;
        int sourceMode;
        volatile boolean done;
        boolean valued;

        MonoTerminalPeekSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, MonoPeekTerminal<T> parent) {
            this.actualConditional = actual;
            this.actual = actual;
            this.parent = parent;
        }

        MonoTerminalPeekSubscriber(Subscriber<? super T> actual, MonoPeekTerminal<T> parent) {
            this.actual = actual;
            this.actualConditional = null;
            this.parent = parent;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case PARENT: {
                    return this.s;
                }
            }
            return InnerOperator.super.scan(key);
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        public void onSubscribe(Subscription s) {
            this.s = s;
            this.queueSubscription = Operators.as(s);
            this.actual.onSubscribe((Subscription)this);
        }

        public void onNext(T t) {
            if (this.sourceMode == 2) {
                this.actual.onNext(null);
            } else {
                if (this.done) {
                    Operators.onNextDropped(t);
                    return;
                }
                this.valued = true;
                if (this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(t, null);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t));
                        return;
                    }
                }
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(t);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e, t));
                        return;
                    }
                }
                this.actual.onNext(t);
                if (this.parent.onAfterTerminateCall != null) {
                    try {
                        this.parent.onAfterTerminateCall.accept(t, null);
                    }
                    catch (Throwable e) {
                        Operators.onErrorDropped(Operators.onOperatorError(this.s, e, t));
                    }
                }
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            if (this.actualConditional == null) {
                this.onNext(t);
                return false;
            }
            this.valued = true;
            if (this.parent.onTerminateCall != null) {
                try {
                    this.parent.onTerminateCall.accept(t, null);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return false;
                }
            }
            if (this.parent.onSuccessCall != null) {
                try {
                    this.parent.onSuccessCall.accept(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return false;
                }
            }
            boolean r = this.actualConditional.tryOnNext(t);
            if (this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(t, null);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(this.s, e, t));
                }
            }
            return r;
        }

        public void onError(Throwable t) {
            block9: {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                if (!this.valued && this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(null, t);
                    }
                    catch (Throwable e) {
                        t = Operators.onOperatorError(null, e, t);
                    }
                }
                try {
                    this.actual.onError(t);
                }
                catch (UnsupportedOperationException use) {
                    if (Exceptions.isErrorCallbackNotImplemented(use) || use.getCause() == t) break block9;
                    throw use;
                }
            }
            if (!this.valued && this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(null, t);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(e));
                }
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 0 && !this.valued) {
                if (this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(null, null);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e));
                        return;
                    }
                }
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(null);
                    }
                    catch (Throwable e) {
                        this.onError(Operators.onOperatorError(this.s, e));
                        return;
                    }
                }
            }
            this.done = true;
            this.actual.onComplete();
            if (this.sourceMode == 0 && !this.valued && this.parent.onAfterTerminateCall != null) {
                try {
                    this.parent.onAfterTerminateCall.accept(null, null);
                }
                catch (Throwable e) {
                    Operators.onErrorDropped(Operators.onOperatorError(e));
                }
            }
        }

        @Override
        public Subscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public T poll() {
            boolean d = this.done;
            Object v = this.queueSubscription.poll();
            if (!this.valued && (v != null || d || this.sourceMode == 1)) {
                this.valued = true;
                if (this.parent.onTerminateCall != null) {
                    try {
                        this.parent.onTerminateCall.accept(v, null);
                    }
                    catch (Throwable e) {
                        throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v));
                    }
                }
                if (this.parent.onSuccessCall != null) {
                    try {
                        this.parent.onSuccessCall.accept(v);
                    }
                    catch (Throwable e) {
                        throw Exceptions.propagate(Operators.onOperatorError(this.s, e, v));
                    }
                }
                if (this.parent.onAfterTerminateCall != null) {
                    try {
                        this.parent.onAfterTerminateCall.accept(v, null);
                    }
                    catch (Throwable t) {
                        Operators.onErrorDropped(Operators.onOperatorError(t));
                    }
                }
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.queueSubscription.isEmpty();
        }

        @Override
        public void clear() {
            this.queueSubscription.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = this.queueSubscription == null ? 0 : ((requestedMode & 4) != 0 ? 0 : this.queueSubscription.requestFusion(requestedMode));
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.queueSubscription == null ? 0 : this.queueSubscription.size();
        }
    }
}

