/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.FluxZip;
import reactor.core.publisher.InnerConsumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoWhen<T, R>
extends Mono<R> {
    final boolean delayError;
    final Publisher<?>[] sources;
    final Iterable<? extends Publisher<?>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;

    <U> MonoWhen(boolean delayError, Publisher<? extends T> p1, Publisher<? extends U> p2, BiFunction<? super T, ? super U, ? extends R> zipper2) {
        this(delayError, new FluxZip.PairwiseZipper(new BiFunction[]{Objects.requireNonNull(zipper2, "zipper2")}), Objects.requireNonNull(p1, "p1"), Objects.requireNonNull(p2, "p2"));
    }

    MonoWhen(boolean delayError, Function<? super Object[], ? extends R> zipper, Publisher<?> ... sources) {
        this.delayError = delayError;
        this.zipper = Objects.requireNonNull(zipper, "zipper");
        this.sources = Objects.requireNonNull(sources, "sources");
        this.sourcesIterable = null;
    }

    MonoWhen(boolean delayError, Function<? super Object[], ? extends R> zipper, Iterable<? extends Publisher<?>> sourcesIterable) {
        this.delayError = delayError;
        this.zipper = Objects.requireNonNull(zipper, "zipper");
        this.sources = null;
        this.sourcesIterable = Objects.requireNonNull(sourcesIterable, "sourcesIterable");
    }

    Mono<R> whenAdditionalSource(Publisher source, BiFunction zipper) {
        Publisher<?>[] oldSources = this.sources;
        if (oldSources != null && this.zipper instanceof FluxZip.PairwiseZipper) {
            int oldLen = oldSources.length;
            Publisher[] newSources = new Publisher[oldLen + 1];
            System.arraycopy(oldSources, 0, newSources, 0, oldLen);
            newSources[oldLen] = source;
            FluxZip.PairwiseZipper z = ((FluxZip.PairwiseZipper)this.zipper).then(zipper);
            return new MonoWhen<T, R>(this.delayError, z, newSources);
        }
        return null;
    }

    public void subscribe(Subscriber<? super R> s) {
        Publisher<?>[] a;
        int n = 0;
        if (this.sources != null) {
            a = this.sources;
            n = a.length;
        } else {
            a = new Publisher[8];
            for (Publisher<?> m : this.sourcesIterable) {
                if (n == a.length) {
                    Publisher[] b = new Publisher[n + (n >> 2)];
                    System.arraycopy(a, 0, b, 0, n);
                    a = b;
                }
                a[n++] = m;
            }
        }
        if (n == 0) {
            Operators.complete(s);
            return;
        }
        WhenCoordinator<R> parent = new WhenCoordinator<R>(s, n, this.delayError, this.zipper);
        s.onSubscribe(parent);
        parent.subscribe(a);
    }

    static final class WhenInner<R>
    implements InnerConsumer<Object> {
        final WhenCoordinator<R> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<WhenInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(WhenInner.class, Subscription.class, "s");
        Object value;
        Throwable error;

        WhenInner(WhenCoordinator<R> parent) {
            this.parent = parent;
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case CANCELLED: {
                    return this.s == Operators.cancelledSubscription();
                }
                case PARENT: {
                    return this.s;
                }
                case ACTUAL: {
                    return this.parent;
                }
                case ERROR: {
                    return this.error;
                }
            }
            return null;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            } else {
                s.cancel();
            }
        }

        public void onNext(Object t) {
            if (this.value == null) {
                this.value = t;
                this.parent.signal();
            }
        }

        public void onError(Throwable t) {
            this.error = t;
            this.parent.signalError(t);
        }

        public void onComplete() {
            if (this.value == null) {
                this.parent.signal();
            }
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class WhenCoordinator<R>
    extends Operators.MonoSubscriber<Object, R> {
        final WhenInner<R>[] subscribers;
        final boolean delayError;
        final Function<? super Object[], ? extends R> zipper;
        volatile int done;
        static final AtomicIntegerFieldUpdater<WhenCoordinator> DONE = AtomicIntegerFieldUpdater.newUpdater(WhenCoordinator.class, "done");

        WhenCoordinator(Subscriber<? super R> subscriber, int n, boolean delayError, Function<? super Object[], ? extends R> zipper) {
            super(subscriber);
            this.delayError = delayError;
            this.zipper = zipper;
            this.subscribers = new WhenInner[n];
            for (int i = 0; i < n; ++i) {
                this.subscribers[i] = new WhenInner(this);
            }
        }

        @Override
        public Object scan(Scannable.Attr key) {
            switch (key) {
                case TERMINATED: {
                    return this.done;
                }
                case BUFFERED: {
                    return this.subscribers.length;
                }
                case DELAY_ERROR: {
                    return this.delayError;
                }
            }
            return super.scan(key);
        }

        @Override
        public Stream<? extends Scannable> inners() {
            return Stream.of(this.subscribers);
        }

        void subscribe(Publisher<?>[] sources) {
            WhenInner<R>[] a = this.subscribers;
            for (int i = 0; i < a.length; ++i) {
                sources[i].subscribe(a[i]);
            }
        }

        void signalError(Throwable t) {
            if (this.delayError) {
                this.signal();
            } else {
                int n = this.subscribers.length;
                if (DONE.getAndSet(this, n) != n) {
                    this.cancel();
                    this.actual.onError(t);
                }
            }
        }

        void signal() {
            WhenInner<R>[] a = this.subscribers;
            int n = a.length;
            if (DONE.incrementAndGet(this) != n) {
                return;
            }
            Object[] o = new Object[n];
            Throwable error = null;
            Throwable compositeError = null;
            boolean hasEmpty = false;
            for (int i = 0; i < a.length; ++i) {
                WhenInner<R> m = a[i];
                Object v = m.value;
                if (v != null) {
                    o[i] = v;
                    continue;
                }
                Throwable e = m.error;
                if (e != null) {
                    if (compositeError != null) {
                        compositeError.addSuppressed(e);
                        continue;
                    }
                    if (error != null) {
                        compositeError = new Throwable("Multiple errors");
                        compositeError.addSuppressed(error);
                        compositeError.addSuppressed(e);
                        continue;
                    }
                    error = e;
                    continue;
                }
                hasEmpty = true;
            }
            if (compositeError != null) {
                this.actual.onError(compositeError);
            } else if (error != null) {
                this.actual.onError(error);
            } else if (hasEmpty || this.zipper == Mono.VOID_FUNCTION) {
                this.actual.onComplete();
            } else {
                R r;
                try {
                    r = Objects.requireNonNull(this.zipper.apply((Object[])o), "zipper produced a null value");
                }
                catch (Throwable t) {
                    this.actual.onError(Operators.onOperatorError(null, t, o));
                    return;
                }
                this.complete(r);
            }
        }

        @Override
        public void cancel() {
            if (!this.isCancelled()) {
                super.cancel();
                for (WhenInner<R> ms : this.subscribers) {
                    ms.cancel();
                }
            }
        }
    }
}

