/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.scheduler;

import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;

final class ImmediateScheduler
implements Scheduler {
    private static final ImmediateScheduler INSTANCE = new ImmediateScheduler();
    static final Disposable EMPTY = () -> {};

    public static Scheduler instance() {
        return INSTANCE;
    }

    private ImmediateScheduler() {
    }

    @Override
    public Disposable schedule(Runnable task) {
        task.run();
        return EMPTY;
    }

    @Override
    public void shutdown() {
        this.dispose();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Scheduler.Worker createWorker() {
        return new ImmediateSchedulerWorker();
    }

    static final class ImmediateSchedulerWorker
    implements Scheduler.Worker {
        volatile boolean shutdown;

        ImmediateSchedulerWorker() {
        }

        @Override
        public Disposable schedule(Runnable task) {
            if (this.shutdown) {
                return Scheduler.REJECTED;
            }
            task.run();
            return EMPTY;
        }

        @Override
        public void shutdown() {
            this.dispose();
        }

        @Override
        public void dispose() {
            this.shutdown = true;
        }

        @Override
        public boolean isDisposed() {
            return this.shutdown;
        }
    }
}

