/*
 * Decompiled with CFR 0.152.
 */
package reactor.util;

import java.util.logging.Level;
import java.util.regex.Matcher;
import reactor.util.Logger;

public abstract class Loggers {
    private static final LoggerFactory LOGGER_FACTORY;

    public static Logger getLogger(String name) {
        return LOGGER_FACTORY.getLogger(name);
    }

    public static Logger getLogger(Class<?> cls) {
        return LOGGER_FACTORY.getLogger(cls.getName());
    }

    Loggers() {
    }

    static {
        LoggerFactory loggerFactory;
        String name = LoggerFactory.class.getName();
        try {
            loggerFactory = new Slf4JLoggerFactory();
            loggerFactory.getLogger(name).debug("Using Slf4j logging framework");
        }
        catch (Throwable t) {
            loggerFactory = new JdkLoggerFactory();
            loggerFactory.getLogger(name).debug("Using JDK logging framework");
        }
        LOGGER_FACTORY = loggerFactory;
    }

    private static class JdkLoggerFactory
    implements LoggerFactory {
        private JdkLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new JdkLogger(java.util.logging.Logger.getLogger(name));
        }
    }

    private static class JdkLogger
    implements Logger {
        private final java.util.logging.Logger logger;

        public JdkLogger(java.util.logging.Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isLoggable(Level.FINEST);
        }

        @Override
        public void trace(String msg) {
            this.logger.log(Level.FINEST, msg);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.log(Level.FINEST, this.format(format, arguments));
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.logger.log(Level.FINEST, msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isLoggable(Level.FINE);
        }

        @Override
        public void debug(String msg) {
            this.logger.log(Level.FINE, msg);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.log(Level.FINE, this.format(format, arguments));
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.logger.log(Level.FINE, msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isLoggable(Level.INFO);
        }

        @Override
        public void info(String msg) {
            this.logger.log(Level.INFO, msg);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.log(Level.INFO, this.format(format, arguments));
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.log(Level.INFO, msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isLoggable(Level.WARNING);
        }

        @Override
        public void warn(String msg) {
            this.logger.log(Level.WARNING, msg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.log(Level.WARNING, this.format(format, arguments));
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.log(Level.WARNING, msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isLoggable(Level.SEVERE);
        }

        @Override
        public void error(String msg) {
            this.logger.log(Level.SEVERE, msg);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.log(Level.SEVERE, this.format(format, arguments));
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.log(Level.SEVERE, msg, t);
        }

        private String format(String from, Object ... arguments) {
            if (from != null) {
                String computed = from;
                if (arguments != null && arguments.length != 0) {
                    for (Object argument : arguments) {
                        computed = computed.replaceFirst("\\{\\}", Matcher.quoteReplacement(argument.toString()));
                    }
                }
                return computed;
            }
            return null;
        }
    }

    private static class Slf4JLogger
    implements Logger {
        private final org.slf4j.Logger logger;

        public Slf4JLogger(org.slf4j.Logger logger) {
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String msg) {
            this.logger.trace(msg);
        }

        @Override
        public void trace(String format, Object ... arguments) {
            this.logger.trace(format, arguments);
        }

        @Override
        public void trace(String msg, Throwable t) {
            this.logger.trace(msg, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String msg) {
            this.logger.debug(msg);
        }

        @Override
        public void debug(String format, Object ... arguments) {
            this.logger.debug(format, arguments);
        }

        @Override
        public void debug(String msg, Throwable t) {
            this.logger.debug(msg, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(String msg) {
            this.logger.info(msg);
        }

        @Override
        public void info(String format, Object ... arguments) {
            this.logger.info(format, arguments);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.info(msg, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String msg) {
            this.logger.warn(msg);
        }

        @Override
        public void warn(String format, Object ... arguments) {
            this.logger.warn(format, arguments);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.warn(msg, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(String msg) {
            this.logger.error(msg);
        }

        @Override
        public void error(String format, Object ... arguments) {
            this.logger.error(format, arguments);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.error(msg, t);
        }
    }

    private static class Slf4JLoggerFactory
    implements LoggerFactory {
        private Slf4JLoggerFactory() {
        }

        @Override
        public Logger getLogger(String name) {
            return new Slf4JLogger(org.slf4j.LoggerFactory.getLogger((String)name));
        }
    }

    private static interface LoggerFactory {
        public Logger getLogger(String var1);
    }
}

