/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.api.classloader.model;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.FilenameUtils;
import org.mule.tools.api.classloader.model.ArtifactCoordinates;
import org.mule.tools.api.classloader.model.util.ArtifactUtils;
import org.mule.tools.api.classloader.model.util.DefaultMavenRepositoryLayoutUtils;

public class Artifact
implements Comparable {
    private ArtifactCoordinates artifactCoordinates;
    private URI uri;

    public Artifact(ArtifactCoordinates artifactCoordinates, URI uri) {
        this.setArtifactCoordinates(artifactCoordinates);
        this.setUri(uri);
    }

    public ArtifactCoordinates getArtifactCoordinates() {
        return this.artifactCoordinates;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"Uri cannot be null");
        this.uri = uri;
    }

    private void setArtifactCoordinates(ArtifactCoordinates artifactCoordinates) {
        Preconditions.checkNotNull((Object)artifactCoordinates, (Object)"Artifact coordinates cannot be null");
        this.artifactCoordinates = artifactCoordinates;
    }

    public String toString() {
        return this.artifactCoordinates.toString();
    }

    public int compareTo(Object that) {
        return this.getSimplifiedMavenCoordinates().compareTo(((Artifact)that).getSimplifiedMavenCoordinates());
    }

    protected String getSimplifiedMavenCoordinates() {
        ArtifactCoordinates coordinates = this.getArtifactCoordinates();
        return coordinates.getGroupId() + ":" + coordinates.getArtifactId() + ":" + coordinates.getVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact that = (Artifact)o;
        return this.getArtifactCoordinates().equals(that.getArtifactCoordinates());
    }

    public int hashCode() {
        return this.getArtifactCoordinates().hashCode();
    }

    public Artifact copyWithParameterizedUri() {
        Artifact newArtifact = new Artifact(this.artifactCoordinates, this.uri);
        File repositoryFolder = new File("repository");
        String artifactFilename = DefaultMavenRepositoryLayoutUtils.getFormattedFileName(ArtifactUtils.toArtifact(newArtifact));
        String newUriPath = DefaultMavenRepositoryLayoutUtils.getFormattedOutputDirectory(repositoryFolder, ArtifactUtils.toArtifact(this)).getPath();
        File newArtifactFile = new File(newUriPath, artifactFilename);
        try {
            this.setNewArtifactURI(newArtifact, newArtifactFile);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not generate URI for resource, the given path is invalid: " + newUriPath, e);
        }
        return newArtifact;
    }

    public void setNewArtifactURI(Artifact newArtifact, File newArtifactFile) throws URISyntaxException {
        String relativePath = FilenameUtils.normalize((String)newArtifactFile.getPath(), (boolean)true);
        newArtifact.setUri(new URI(relativePath));
    }
}

