/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import java.math.BigInteger;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.config.spring.internal.dsl.SchemaConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ComplexContent;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.LocalComplexType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;

final class ConnectionProviderSchemaDelegate {
    private final SchemaBuilder builder;

    ConnectionProviderSchemaDelegate(SchemaBuilder builder) {
        this.builder = builder;
    }

    void registerConnectionProviderElement(ConnectionProviderModel providerModel, DslElementSyntax elementSyntax) {
        TopLevelElement providerElement = new TopLevelElement();
        providerElement.setName(elementSyntax.getElementName());
        providerElement.setSubstitutionGroup(SchemaConstants.MULE_EXTENSION_CONNECTION_PROVIDER_ELEMENT);
        LocalComplexType complexType = new LocalComplexType();
        providerElement.setComplexType(complexType);
        ExtensionType providerType = new ExtensionType();
        providerType.setBase(SchemaConstants.MULE_EXTENSION_CONNECTION_PROVIDER_TYPE);
        ComplexContent complexContent = new ComplexContent();
        complexContent.setExtension(providerType);
        complexType.setComplexContent(complexContent);
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(providerElement);
        ExplicitGroup sequence = new ExplicitGroup();
        sequence.setMinOccurs(BigInteger.ZERO);
        sequence.setMaxOccurs("1");
        this.builder.addInfrastructureParameters(providerType, (ParameterizedModel)providerModel, sequence);
        providerModel.getParameterGroupModels().forEach(group -> {
            if (!group.isShowInDsl()) {
                this.builder.addParameterToSequence(this.builder.registerParameters(providerType, group.getParameterModels()), sequence);
            } else {
                this.builder.addInlineParameterGroup((ParameterGroupModel)group, sequence);
            }
        });
        providerType.setSequence(sequence);
    }
}

