/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class FnLang
extends Function {
    private static Collection<SeqType> _expected_args = null;

    public FnLang() {
        super(new QName("lang"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnLang.lang(args, ec);
    }

    public static ResultSequence lang(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        Collection<ResultSequence> cargs = Function.convert_arguments(args, FnLang.expected_args());
        Iterator<ResultSequence> citer = cargs.iterator();
        ResultSequence arg1 = citer.next();
        ResultSequence arg2 = null;
        if (cargs.size() == 1) {
            if (ec.getContextItem() == null) {
                throw DynamicError.contextUndefined();
            }
            arg2 = (AnyType)ec.getContextItem();
        } else {
            arg2 = citer.next();
        }
        String lang = "";
        if (!arg1.empty()) {
            lang = ((XSString)arg1.first()).value();
        }
        if (!(arg2.first() instanceof NodeType)) {
            throw DynamicError.invalidType();
        }
        NodeType an = (NodeType)arg2.first();
        return new XSBoolean(FnLang.test_lang(an.node_value(), lang));
    }

    private static boolean test_lang(Node node, String lang) {
        Node parent;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if (!"xml:lang".equals(attr.getName())) continue;
                String xmllangValue = attr.getValue();
                int hyphenIndex = xmllangValue.indexOf(45);
                if (hyphenIndex > -1) {
                    xmllangValue = xmllangValue.substring(0, hyphenIndex);
                }
                String langLanguage = lang;
                if (lang.length() > 2) {
                    langLanguage = lang.substring(0, 2);
                }
                return xmllangValue.equalsIgnoreCase(langLanguage);
            }
        }
        if ((parent = node.getParentNode()) == null) {
            return false;
        }
        return FnLang.test_lang(parent, lang);
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            _expected_args.add(new SeqType(new XSString(), 3));
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

