/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;

public class FnResolveURI
extends Function {
    private static Collection<SeqType> _expected_args = null;

    public FnResolveURI() {
        super(new QName("resolve-uri"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnResolveURI.resolveURI(args, ec);
    }

    public static ResultSequence resolveURI(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        if (ec.getStaticContext().getBaseUri() == null) {
            throw DynamicError.noBaseURI();
        }
        Collection<ResultSequence> cargs = args;
        Iterator<ResultSequence> argit = cargs.iterator();
        ResultSequence relativeRS = argit.next();
        ResultSequence baseUriRS = null;
        if (argit.hasNext()) {
            baseUriRS = argit.next();
        }
        if (relativeRS.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item relativeURI = relativeRS.first();
        String resolvedURI = null;
        if (baseUriRS == null) {
            resolvedURI = FnResolveURI.resolveURI(ec.getStaticContext().getBaseUri().toString(), relativeURI.getStringValue());
        } else {
            Item baseURI = baseUriRS.first();
            resolvedURI = FnResolveURI.resolveURI(baseURI.getStringValue(), relativeURI.getStringValue());
        }
        return new XSAnyURI(resolvedURI);
    }

    private static String resolveURI(String base, String relative) throws DynamicError {
        String resolved = null;
        try {
            URI baseURI = new URI(base);
            resolved = baseURI.resolve(relative).toString();
        }
        catch (Exception ex) {
            throw DynamicError.errorResolvingURI(ex);
        }
        return resolved;
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            _expected_args.add(new SeqType(3));
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

